// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.57 $

#include "knodawin.h"
#include "knodawinbase.h"
#include <kstdaction.h>
#include <kaction.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qworkspace.h>
#include "knodaprogrambase.h"

knodamainwindow::knodamainwindow( QWidget* parent,hk_kdeworkspace* w,  const char* name, WFlags fl,const QString& database,const QString& form )
: KMainWindow( parent, name, fl ) ,hk_class()
{
    //setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 400, 450 ) );
    if (w)setMaximumSize( QSize( 400, 450 ) );
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
//   setXMLFile("knodaui.rc");
    p_closeaction=new KAction(i18n("&Close"),"fileclose",0,this,SLOT(close_slot()),actionCollection(),"closedatabase");

    p_mainwindow = new knodamainwindowbase(this,w,name,fl,database,form);
    setCentralWidget(p_mainwindow);

//createGUI(0L);
}


knodamainwindow::~knodamainwindow()
{
    delete p_closeaction;
}


void knodamainwindow::set_connection(hk_connection* c)
{

    p_mainwindow->set_connection(c);
    if (c)
    {
        hk_string s=c->drivername()+" "+c->user()+"@"+c->host()+":"+ulongint2string(c->tcp_port());
        setCaption(QString::fromLocal8Bit(s.c_str()));
    }

}
void knodamainwindow::closeEvent(QCloseEvent*event)
{
 if (p_mainwindow)
  {
 if (p_mainwindow->database())
   {
     bool while_printing=false;
     hk_string n;
     list<hk_presentation*>* p=p_mainwindow->database()->presentationlist();
     list<hk_presentation*>::iterator it=p->begin();
     while (it!=p->end()&& !while_printing)
     {
      hk_report* r=dynamic_cast<hk_report*>(*it);
      if (r)
      {
        if (r->while_executing()) 
	  {
	   while_printing=true;
	   n=r->name();
	  } 
      }
      
      ++it;
     }
   
     if (while_printing)
     {
       show_warningmessage(replace_all("%1",hk_translate("Cannot close now, because the report '%1' is executing. Cancel it first"),n));
       
     event->ignore();
     }
     else
     event->accept();
   }


}
}


void knodamainwindow::close_slot(void)
{
 
    close();
  
}


void knodamainwindow::showEvent(QShowEvent* event)
{
   KMainWindow::showEvent(event);
}
