// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_kdesubformdialog.h"
#include "hk_kdedbdesigner.h"
#include <hk_datasource.h>
#include <hk_presentation.h>
#include <hk_subform.h>
#include <hk_form.h>
#include <qtable.h>
#include <qpushbutton.h>



hk_kdesubformdialog::hk_kdesubformdialog( hk_subform* subform,QWidget* parent,  const char* name, bool modal, WFlags fl )
    : hk_kderelationdialogbase( parent, name, modal, fl )
{
p_subform=subform;
p_masterds=p_subform->datasource();
const int w=180;
grid->installEventFilter(this);
ok_button->installEventFilter(this);
cancel_button->installEventFilter(this);
grid->setColumnWidth(0,w);
grid->setColumnWidth(1,w);
p_form=new hk_form();

if (p_masterds)p_form->set_database(p_masterds->database());
p_form->load_form(p_subform->name());
p_slaveds=p_form->datasource();



if (p_masterds)
{grid->horizontalHeader()->setLabel(0,QString::fromLocal8Bit(
			p_masterds->name().c_str()));
set_stringlist(&p_mastercollist,p_masterds->columns());
}
if (p_slaveds)
{grid->horizontalHeader()->setLabel(1,QString::fromLocal8Bit(
			p_slaveds->name().c_str()));
set_stringlist(&p_slavecollist,p_slaveds->columns());
}
add_row();
//ok_button->setEnabled(false);
set_existing_fields();
connect(grid,SIGNAL(valueChanged(int,int)),this,SLOT(slot_data_changed(int,int)));
}



hk_kdesubformdialog::~hk_kdesubformdialog()
{
delete p_form;
}





void hk_kdesubformdialog::add_row(void)
{

//cerr <<p_mastercollist<<endl;
cerr <<"add_row"<<endl;
QComboTableItem* masteritem=new QComboTableItem(grid,p_mastercollist);
QComboTableItem* slaveitem=new QComboTableItem(grid,p_slavecollist);
grid->setNumRows(grid->numRows()+1);
grid->setItem(grid->numRows()-1,0,masteritem);
grid->setItem(grid->numRows()-1,1,slaveitem);
cerr <<"ENDE add_row"<<endl;

}





void hk_kdesubformdialog::set_stringlist(QStringList* strlist,list<hk_column*>* collist)
{
cerr <<"set_stringlist"<<endl;
    strlist->clear();
    strlist->append("");
   list<hk_column*>::iterator it= collist->begin();
   while (it!=collist->end())
   { cerr <<"add "<<(*it)->name()<<endl;
       strlist->append(QString::fromLocal8Bit((*it)->name().c_str()));
     ++it;
   }
cerr <<"ende set_stringlist"<<endl;
}





void hk_kdesubformdialog::set_existing_fields(void)
{
if (!p_subform)return;
cerr <<"set_existing_fields"<<endl;
list<dependingclass>* l=p_subform->depending_on_fields();
list<dependingclass>::iterator it=l->begin();
cerr <<"vor while"<<endl;
while (it!=l->end())
	 {
	    int masterpos=textposition(&p_mastercollist,(*it).masterfield);
		if (masterpos>=0)((QComboTableItem*)(grid->item(grid->numRows()-1,0)))->setCurrentItem(masterpos);
	    int dependingpos=	textposition(&p_slavecollist,(*it).dependingfield);
		if (dependingpos>=0)((QComboTableItem*)(grid->item(grid->numRows()-1,1)))->setCurrentItem(dependingpos);
		cerr <<"master:"<<(*it).masterfield<<" depending:"<<(*it).dependingfield<<endl;
		++it;
		cerr <<"vor addrow"<<endl;
		add_row();
		cerr<<"nach addrow"<<endl;
	}

cerr <<"ENDE set_existing_fields"<<endl;

}




int hk_kdesubformdialog::textposition(QStringList* thelist,const hk_string& txt )
{ 

cerr <<"textposition: '"<<txt<<"'"<<endl;
   for ( QStringList::Iterator it = thelist->begin(); it != thelist->end(); ++it ) 
   {
        cout << *it << " : ";
    }
    cout << endl;

return thelist->findIndex(QString::fromLocal8Bit(txt.c_str()));
}



int hk_kdesubformdialog::masterindex(const QString& string)
{
cerr <<"masterindex "<<string<<endl;
return textposition(&p_mastercollist,string.local8Bit().data());
}




int hk_kdesubformdialog::slaveindex(const QString& string)
{
cerr <<"slaveindex "<<string<<endl;
return textposition(&p_slavecollist,string.local8Bit().data());
}




void hk_kdesubformdialog::ok_button_clicked(void)
{
p_subform->clear_depending_fields();
for (int row=0;row<grid->numRows()-1;++row)
  {
    hk_string mastertxt=grid->item(row,0)->text().local8Bit().data();
    hk_string slavetxt=grid->item(row,1)->text().local8Bit().data();
    if (mastertxt.size()>0 && slavetxt.size()>0)
        p_subform->add_depending_fields(slavetxt,mastertxt,true);
   }


accept();
}




void hk_kdesubformdialog::slot_data_changed(int row, int /*col*/)
{  
  if (row==grid->numRows()-1 
  	&& grid->item(row,0)
	&&  !grid->item(row,0)->text().isEmpty() 
	&& !grid->item(row,1)->text().isEmpty())
  	{
		add_row();
	}

}





void hk_kdesubformdialog::keyPressEvent(QKeyEvent* /*event*/)
{
    /*if (event->key()==Key_Delete)
    {
        delete_rows();
    }*/



}	



void hk_kdesubformdialog::delete_rows(void)
{
 cerr <<"hk_kdesubformdialog::delete_rows"<<endl;
 int beginrow=grid->selection(0).topRow();
 int endrow=grid->selection(0).bottomRow();
 if (endrow==grid->numRows()-1) --endrow;
if (beginrow>-1&&endrow>=beginrow)
{
QMemArray<int> a(endrow-beginrow+1);
int c=0;//cerr <<"a new ="<<endrow-beginrow+1<<endl;
	for (int i=beginrow;i<=endrow;++i)
	{
	 a[c]=i;//cerr <<"a["<<c<<"]="<<i<<endl;
	 ++c;
	}
	grid->removeRows(a);
}
else
{
//cerr <<"delete_row "<<grid->currentRow()<<endl;
if (grid->currentRow()>-1 &&grid->currentRow()<grid->numRows()-1) 
	grid->removeRow(grid->currentRow());
}

}




bool hk_kdesubformdialog::eventFilter(QObject* object,QEvent* e)
{
 QKeyEvent* event=dynamic_cast<QKeyEvent*>(e);
 if (event  && event->key()==Qt::Key_Delete && event->type()==QEvent::KeyRelease)
   {
       delete_rows(); 
       //event->accept();
       return true;
   }
  else return hk_kderelationdialogbase::eventFilter(object,e);
}


