// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.117 $

#include <hk_kdesimplegrid.h>
#include <hk_kdesimplegrid.moc>
#include <qdrawutil.h>
#include <list>
#include <locale.h>
#include <hk_datetime.h>
#include <qscrollbar.h>
#include <qheader.h>
#include <qkeycode.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qpaintdevicemetrics.h>
#include <qfontmetrics.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qapplication.h>
#include <qpopupmenu.h>
#include <qiconset.h>
#include <qlistbox.h>
#include <qtooltip.h>
#include "hk_kdesimpleform.h"
#include "hk_kdegrid.h"
#include "hk_kdegridcolumndialog.h"
#include "hk_dsgridcolumn.h"
#include "hk_kdememo.h"
#include <qlabel.h>
#include <qlistview.h>
#include <qstyle.h>
#include <qdragobject.h>
#include <qdatetime.h>
#include "hk_kdelineedit.h"
#include "hk_kdecombobox.h"
#include <hk_dsgridcolumn.h>
#include <hk_dsboolean.h>
#include <hk_database.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kprinter.h>

class hk_griddrag: public QTextDrag
{
public:
  hk_griddrag (const QString& text,QWidget* dragsource=0,const char* name=0)
   :QTextDrag(text,dragsource,name)
     {
       setSubtype("tab-separated-values");
     }
static  bool canDecode(const QMimeSource* s)
    {
       //const char* f;
/*    for (int i=0; (f=s->format(i)); i++)
    {
	cerr <<"decode: "<<f<<endl;
    }*/
    bool b= QTextDrag::canDecode(s);

    //cerr <<"canDecode: "<<(b?"TRUE":"FALSE")<<endl;
    return b;
    }
const char* format(int i) const
{
  if (i==0) return "text/tab-separated-values";
  --i;
  return QTextDrag::format(i);

}
};


internalcheckbox::internalcheckbox(QWidget* g):QFrame(g),hk_dsboolean()
{
#ifdef HK_DEBUG
//wanna_debug(true);
    hkdebug ("internalcheckbox::internalcheckbox");
#endif
    p_cursoron=false;
    p_blinkspeed=500;
    connect(&p_blinktimer, SIGNAL(timeout()),this,SLOT(blinkcursorslot()));

}


internalcheckbox::~internalcheckbox(void)
{
#ifdef HK_DEBUG
    hkdebug ("internalcheckbox::~internalcheckbox");
#endif

}


void internalcheckbox::blinkcursorslot(void)
{
#ifdef HK_DEBUG
// hkdebug ("internalcheckbox::blinkcursorslot");
#endif
    if (hasFocus()||p_cursoron)
    {
        p_cursoron=!p_cursoron;
        repaint();
        if (!hasFocus()) p_blinktimer.stop();
        else if(!p_blinktimer.isActive()) p_blinktimer.start(p_blinkspeed);
    }
}


bool internalcheckbox::datasource_enable(void)
{
#ifdef HK_DEBUG
    hkdebug ("internalcheckbox::datasource_enable");
#endif
    blinkcursorslot();
    return hk_dsboolean::datasource_enable();
}


void internalcheckbox::blinkon()
{
#ifdef HK_DEBUG
    hkdebug ("internalcheckbox::blinkon");
#endif
    if ( !hasFocus() )
        return;

    p_blinktimer.start( p_cursoron?QApplication::cursorFlashTime() / 2 : 0, TRUE );
    blinkcursorslot();
}


void internalcheckbox::focusInEvent(QFocusEvent * f)
{
#ifdef HK_DEBUG
    hkdebug("internalcheckbox::focusInEvent");
#endif
    QFrame::focusInEvent(f);
    p_cursoron=true;
    blinkcursorslot();

}


void internalcheckbox::paintEvent(QPaintEvent*)
{
#ifdef HK_DEBUG
//hkdebug ("internalcheckbox::paintEvent");
#endif
    QPainter painter(this);
    QColorGroup farbe=colorGroup();
    int square=10;
    int left=(contentsRect().width()+1-square)/2;
    int top=(contentsRect().height()+1-square)/2 ;
    painter.fillRect( 0, 0, QWidget::width(), QWidget::height(),  farbe.brush( QColorGroup::Base ) );
    if (p_cursoron) qDrawShadeRect(&painter,left,top,square,square,farbe,false,1);
    int draw=0;
    if (column()!=NULL)
    {
        if (column()->has_changed())
        {
            if (column()->changed_data_is_nullvalue()) draw=2;
	    else
            if (column()->changed_data_asbool()) draw=1;
	    
        }
        else
        {
            if (column()->is_nullvalue()) draw=2;
	    else
	    if(column()->asbool()) draw=1;
        }
    }






    switch (draw)
    {
    case 1: { // TRUE

        const QBrush brush =QBrush(colorGroup().highlightedText());
        qDrawPlainRect(&painter,left+3,top+3,square/2,square/2,colorGroup().dark(),1,&brush);
            break;
	    }
   case 2:	 {// NULL Value
         QColor nullcolor=colorGroup().text();
        QBrush brush =QBrush(nullcolor);
	brush.setStyle(QBrush::Dense5Pattern);
        qDrawPlainRect(&painter,left+2,top+2,square-4,square-4,nullcolor,0,&brush);
	    
	    
	    
	    break;
	    }
   default:;	        
   }







}


void internalcheckbox::keyPressEvent(QKeyEvent* e)
{
#ifdef HK_DEBUG
    hkdebug ("internalcheckbox::keyPressEvent");
#endif
    if ((e->key()==Key_Space)&&(column()!=NULL))
    {
        if (column()->has_changed())
            column()->set_asbool(!column()->changed_data_asbool());
        else
            column()->set_asbool(!column()->asbool());
    }

    blinkon();

}


void internalcheckbox::mousePressEvent(QMouseEvent* )
{
#ifdef HK_DEBUG
    hkdebug ("internalcheckbox::mousePressEvent");
#endif
    if (column()!=NULL)
    {
        if (column()->has_changed())
	{
           if (column()->changed_data_is_nullvalue())column()->set_asbool(true);
	   else
	   if ( column()->changed_data_asbool()) column()->set_asbool(false);
	   else
	   {
	    if (column()->is_notnull())column()->set_asbool(true);
	    else
	    column()->set_asnullvalue();
	   } 
	}   
        else
	{
           if (column()->is_nullvalue())column()->set_asbool(true);
	   else
	   if ( column()->asbool()) column()->set_asbool(false);
	   else
	   {
	    if (column()->is_notnull())column()->set_asbool(true);
	    else
	    column()->set_asnullvalue();
	   } 
//            column()->set_asbool(!column()->asbool());
	}    
    }else cerr <<"internalcheckbox::mousePressEvent() ist NULL"<<endl;
    blinkcursorslot();
}


//****************************************************************
//***   hk_kdesimplegrid begin                                 ***
//****************************************************************
class hk_kdesimplegridprivate
{
public:
hk_kdesimplegridprivate()
	{
	  p_resizeverticalheader=false;
	  autoresizeverticalheader=false;
	  newsize=20;
	}
bool p_resizeverticalheader;
bool autoresizeverticalheader;
int newsize;

};
//*******************************
//***    hk_kdesimplegrid     ***
//*******************************

hk_kdesimplegrid::hk_kdesimplegrid(hk_kdegrid* grid, QLabel* statusbar,hk_kdesimpleform* form):QTable(grid),
hk_dsvisible(form)
{

#ifdef HK_DEBUG
    hkclassname("hk_kdesimplegrid");
    hkdebug("hk_kdesimplegrid::hk_kdesimplegrid");
//wanna_debug(true);
#endif
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    p_grid=grid;
    p_currentrow=0;
    p_currentcolumn=0;
    p_hk_kdesimplegridprivate=new hk_kdesimplegridprivate();
    p_combobox_created=false;
    setSelectionMode(Single);
    viewport()->setBackgroundMode(PaletteDark);
    p_statusbar=statusbar;
    setColumnMovingEnabled(true);
    arrow_image=loader->loadIcon("gridcursor",KIcon::User   );
    horizontalHeader()->setMovingEnabled(true);
    installEventFilter( this );
    viewport()->setAcceptDrops(true);
    qApp->installEventFilter(this);
    connect (this,SIGNAL(currentChanged(int,int)),this,SLOT(row_changed(int,int)));
    connect (this,SIGNAL(contextMenuRequested(int,int,const QPoint&)),this,SLOT(show_contextmenu(int,int,const QPoint&)));
    connect (this,SIGNAL(selectionChanged()),this,SLOT(selection_changed()));
    connect (this,SIGNAL(clicked(int,int,int,const QPoint&)),this,SLOT(slot_mouse_clicked()));
    connect (this,SIGNAL(doubleClicked(int,int,int,const QPoint&)),this,SLOT(slot_mouse_doubleclicked()));
    connect(horizontalHeader() ,SIGNAL(sizeChange(int,int,int)),this,SLOT(set_columnwidth(int,int,int)));
    connect(horizontalHeader(), SIGNAL(indexChange(int,int,int)),this,SLOT(column_moved(int,int,int)));
    connect(verticalHeader(), SIGNAL(pressed(int)),this,SLOT(setFocus()));
    connect(verticalHeader(), SIGNAL(sizeChange(int,int,int)),this,SLOT(slot_verticalheader_resized(int,int,int)));
    connect(this,SIGNAL(contentsMoving(int,int)),this,SLOT(slot_content_moving(int,int)));
    verticalHeader()->setTracking(false);
    setDragEnabled(true);
    QFont f=QWidget::font();
   cerr <<"fontsize:"<<f.pointSize()<<" rowheight:"<<p_grid->rowheight()<<endl;
}


hk_kdesimplegrid::~hk_kdesimplegrid(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::destructor");
#endif
delete p_hk_kdesimplegridprivate;
}


QTableItem* hk_kdesimplegrid::item(int ,int ) const
{
    return NULL;
}


hk_column* hk_kdesimplegrid::actual_column(void)
{
    return p_grid->gridcolumn(currentColumn())->column();
}


void hk_kdesimplegrid::widget_specific_enable_disable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::widget_specific_enable_disable");
#endif
    if (datasource()!=NULL)
    {
    clear_vertical_header();
    p_currentrow=0;
    p_currentcolumn=0;
    paint_vertical_header();
    //columns_created();
    }
    else
    {
        setEnabled(false);
    }
}


void hk_kdesimplegrid::columns_created(void)
{
if (!datasource()) return;
clear_vertical_header();

        setSorting(!datasource()->is_rawsql());
        if (datasource()->is_enabled())
        {
            if(datasource()->columns()!=NULL)
                setNumCols(p_grid->columnscount());
		
	   int newnumrows=datasource()->max_rows()+((datasource()->is_readonly()||p_grid->is_readonly())?0:1);	
	   if (newnumrows>numRows())
	    {
   		QString r;
    		r.setNum(numRows());
    		verticalHeader()->setLabel(numRows()-1,no_image,r);
	    
	    }
            setNumRows(newnumrows);
            //paint_vertical_header();
            setEnabled(true);
            for(unsigned int count=0;count<p_grid->columnscount();count++)
            {
                horizontalHeader()->setLabel(horizontalHeader()->mapToLogical(count),
                    (p_grid->gridcolumn(count)->displayname().length()==0?QString::fromLocal8Bit (p_grid->gridcolumn(count)->displayname().size()==0?
                    p_grid->gridcolumn(count)->columnname().c_str():
                p_grid->gridcolumn(count)->displayname().c_str())
                    :QString::fromLocal8Bit (p_grid->gridcolumn(count)->displayname().c_str())),
                    p_grid->gridcolumn(count)->columnwidth());
                setColumnWidth(count,p_grid->gridcolumn(count)->columnwidth());
                horizontalHeader()->setMovingEnabled(true);
                set_statustext();

            }
            horizontalHeader()->setSortIndicator(-1);

        }
        else
        {
            setNumRows(1);
            setNumCols(1);
            setEnabled(false);
        }
widget_specific_rowheight_changes();
paint_vertical_header();
}



void hk_kdesimplegrid::resizeData(int )
{

}


QString hk_kdesimplegrid::text(int row, int col) const
{
    if (p_grid->gridcolumn(col)->column()==NULL) return "";
    return QString::fromLocal8Bit(p_grid->gridcolumn(col)->column()->asstring_at(row,true).c_str());
}


void hk_kdesimplegrid::paintCell(QPainter* p,int row, int col, const QRect& cr,bool selected, const QColorGroup &cg)
{
    QPen txtpen=p->pen();
    txtpen.setColor(colorGroup().text());
    p->setPen(txtpen);
    QColorGroup colgrp=cg;
    if (row%2!=0)colgrp.setColor(QColorGroup::Base,KGlobalSettings::alternateBackgroundColor());
    QTable::paintCell(p,row,col,cr,selected,colgrp);
    if (datasource()!=NULL)
        if ((datasource()->is_enabled())&&((unsigned int)col<p_grid->columnscount()))
    {
        switch(p_grid->gridcolumn(col)->columntype())
        {
            case hk_dsgridcolumn::columnbool :    paint_boolcell(p,row,col,cr,selected,cg);
            break;
            case hk_dsgridcolumn::columncombo:    paint_combocell(p,row,col,cr,selected,cg);
            break;

            default              :    paint_textcell (p,row,col,cr,selected,cg);
        }
    }
}


void hk_kdesimplegrid::paint_textcell(QPainter* p,int row, int col, const QRect& ,bool selected , const QColorGroup&)
{
    if (p_grid->gridcolumn(col)->column()==NULL) return;
bool is_null=false;
    Qt::AlignmentFlags f;
    QPen pen=p->pen();
    bool currentcell=currentRow()==row && currentColumn()==col;
    switch (p_grid->gridcolumn(col)->alignment())
    {
        case hk_dsdatavisible::alignright    : f= Qt::AlignRight;
        break;
        case hk_dsdatavisible::aligncenter    : f= Qt::AlignHCenter;
        break;
        default       : f= Qt::AlignLeft;

    }
    QString txt;
    if (p_grid->gridcolumn(col)->column()->has_changed()&&
        (((unsigned int)row==datasource()->row_position()&&datasource()->mode()!=hk_datasource::mode_insertrow)||
        ((unsigned int)row==datasource()->max_rows()&&datasource()->mode()==hk_datasource::mode_insertrow)) )
    {
        txt=QString::fromLocal8Bit (p_grid->gridcolumn(col)->column()->changed_data_asstring(true).c_str());
	is_null=p_grid->gridcolumn(col)->column()->changed_data_is_nullvalue();
    }
    else
    {
        if ((unsigned)row==datasource()->max_rows())
        {
                                                  //&&col==currentColumn())
            if (p_grid->gridcolumn(col)->use_defaultvalue())
	    {
                txt=QString::fromLocal8Bit (p_grid->gridcolumn(col)->defaultvalue().c_str());
		is_null=txt.isEmpty();
	    }
        }
        else
	{
            txt=QString::fromLocal8Bit (p_grid->gridcolumn(col)->column()->asstring_at(row,true).c_str());
	    is_null=p_grid->gridcolumn(col)->column()->is_nullvalue_at(row);
	}    
    }
    if ((!is_null&&is_numerictype(p_grid->gridcolumn(col)->column())&&p_grid->gridcolumn(col)->column()->columntype()!=hk_column::auto_inccolumn &&txt.length()>0)
        || (p_grid->gridcolumn(col)->column()->columntype()==hk_column::auto_inccolumn
        && (unsigned int)row!=datasource()->max_rows())
        )
        txt=format_number(txt.local8Bit().data(),true,p_grid->gridcolumn(col)->use_numberseparator(),p_grid->gridcolumn(col)->commadigits(),locale()).c_str();

//if (row!=currentRow())
    {
        const unsigned int maxdisplaysize=256;
        if (txt.length()>maxdisplaysize)
        {
            txt.truncate(maxdisplaysize);
            txt+="[...]";
        }
    }
    QPen txtpen=pen;
    txtpen.setColor(selected&&!(currentcell && hasFocus())?colorGroup().highlightedText():colorGroup().text());
    p->setPen(txtpen);
    p->drawText(2,3,columnWidth(col)-7,rowHeight(row),f,txt);

    p->setPen(pen);
}


void hk_kdesimplegrid::paint_combocell(QPainter* p,int row, int col, const QRect& /*cr*/,bool selected,const QColorGroup &/*cg*/)
{
    if (p_grid->gridcolumn(col)->column()==NULL) return;
    Qt::AlignmentFlags f;
    bool currentcell=currentRow()==row && currentColumn()==col;
    switch (p_grid->gridcolumn(col)->alignment())
    {
        case hk_dsdatavisible::alignright    : f= Qt::AlignRight;
        break;
        case hk_dsdatavisible::aligncenter    : f= Qt::AlignHCenter;
        break;
        default       : f= Qt::AlignLeft;

    }

    QString txt;
    if (p_grid->gridcolumn(col)->column()->has_changed()&&
        ((unsigned int)row==datasource()->row_position()||
        ((unsigned int)row==datasource()->max_rows()&&datasource()->mode()==hk_datasource::mode_insertrow)) )
    {
        txt=QString::fromLocal8Bit (p_grid->gridcolumn(col)->value_at(row).c_str());
    }
    else
    {
        if ((unsigned)row==datasource()->max_rows())
        {
                                                  //&&col==currentColumn())
            if (p_grid->gridcolumn(col)->use_defaultvalue())
                txt="";
        }
        else
            txt=QString::fromLocal8Bit (p_grid->gridcolumn(col)->value_at(row).c_str());
    }
    QPen txtpen=p->pen();

    txtpen.setColor(selected&&!(currentcell && hasFocus())?colorGroup().highlightedText():colorGroup().text());
    p->setPen(txtpen);
    p->drawText(2,3,columnWidth(col)-7,rowHeight(row),f,txt);

}


void hk_kdesimplegrid::paint_boolcell(QPainter* painter,int row, int col, const QRect& ,bool selected ,const QColorGroup &cg)
{
    QColorGroup farbe=cg;
    int square=10;
    int left=(columnWidth(col)-square)/2;
    int top=(rowHeight(row)-square)/2 ;
    qDrawShadeRect(painter,left,top,square,square,farbe,false,1);

    int draw=0;
    bool currentcell=currentRow()==row && currentColumn()==col;

    if (p_grid->gridcolumn(col)!=NULL&& p_grid->gridcolumn(col)->column()!=NULL)
    {
        if ((row==currentRow()) && (p_grid->gridcolumn(col)->column()->has_changed()))
        {
            draw=p_grid->gridcolumn(col)->column()->changed_data_asbool();
        }
        else
	{
            if (p_grid->gridcolumn(col)->column()->is_nullvalue_at(row)) draw=2;
	    else
	    if (p_grid->gridcolumn(col)->column()->asbool_at(row)) draw=1;
	}    
    }
    switch (draw)
    {
    case 1: { // TRUE

        const QBrush brush =QBrush(selected&&!(currentcell && hasFocus())?colorGroup().highlightedText():colorGroup().text());
        qDrawPlainRect(painter,left+3,top+3,square/2,square/2,colorGroup().dark(),1,&brush);
            break;
	    }
   case 2:	 {// NULL Value
         QColor nullcolor=colorGroup().text();
        QBrush brush =QBrush(nullcolor);
	brush.setStyle(QBrush::Dense5Pattern);
        qDrawPlainRect(painter,left+2,top+2,square-4,square-4,nullcolor,0,&brush);
            break;
	    }
   default:;	        
   }
}


void hk_kdesimplegrid::setCellContentFromEditor( int , int )
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::setCellContentFromEditor");
#endif
}


QWidget* hk_kdesimplegrid::createEditor(int row, int col,bool ) const
{
#ifdef HK_DEBUG
//cout <<"hk_kdesimplegrid::createEditor"<<endl;
#endif
    if (p_grid->gridcolumn(col)->column()==NULL )   return 0;
    if ( (isReadOnly() || isRowReadOnly( row ) || isColumnReadOnly( col )
        ||p_grid->gridcolumn(col)->is_readonly()||p_grid->gridcolumn(col)->column()->is_readonly())
        &&p_grid->gridcolumn(col)->columntype()== hk_dsgridcolumn::columnbool)return 0;

    QWidget* e=NULL;
    switch  (p_grid->gridcolumn(col)->columntype())
    {
        case hk_dsgridcolumn::columnbool:
        {
            internalcheckbox* i = new internalcheckbox(viewport());
            e=i;
            i->set_datasource(p_grid->datasource());
            i->set_columnname(p_grid->gridcolumn(col)->columnname());
	    i->set_gridcolumn(p_grid->gridcolumn(col));

            break;
        }
        case hk_dsgridcolumn::columncombo:
        {
            /*if(isReadOnly() || isRowReadOnly( row ) || isColumnReadOnly( col )
                ||p_grid->gridcolumn(col)->is_readonly()||p_grid->gridcolumn(col)->column()->is_readonly())
            {
                e=create_lineeditor(row,col);
                break;
            }*/
            hk_kdecombobox* l = new hk_kdecombobox( viewport());
            p_combobox_created=true;
            e=l;
            hk_dsgridcolumn* c=p_grid->gridcolumn(col);
            l->set_columnname(c->columnname());
            l->set_viewcolumnname(c->viewcolumnname());
            l->set_listcolumnname(c->listcolumnname());
            l->set_alignment(p_grid->gridcolumn(col)->alignment());
            l->set_numberformat(p_grid->gridcolumn(col)->use_numberseparator(),p_grid->gridcolumn(col)->commadigits());
            l->set_defaultvalue(p_grid->gridcolumn(col)->defaultvalue());
            l->set_columnname(p_grid->gridcolumn(col)->columnname());
            l->set_readonly((isReadOnly() || isRowReadOnly( row ) || isColumnReadOnly( col )||p_grid->gridcolumn(col)->is_readonly()));
            l->set_font(p_grid->hk_dsgrid::font());
            l->set_gridcolumn(p_grid->gridcolumn(col));


            if (p_grid->presentation())
                l->set_listdatasource(p_grid->presentation()->get_datasource(c->listdatasourcename()));
            else
            {
                if (p_grid->datasource())
                {
                    hk_database* db=p_grid->datasource()->database();
                    hk_datasource* ds=db->load_datasource(c->listdatasourcename(),c->listdatasourcetype());
                    l->set_listdatasource(ds);
                    if (ds)ds->enable();
                }
            }
            l->set_datasource(p_grid->datasource());
            if (l->lineEdit())l->lineEdit()->selectAll();
            break;
        }
        default:
	{
	hk_column* c=p_grid->gridcolumn(col)->column();
	if (c)
	{
	 if (c->columntype()==hk_column::memocolumn)
	 {
    hk_kdememo* l = new hk_kdememo( viewport());
    l->setPaletteBackgroundColor(paletteBackgroundColor());
    l->set_alignment(p_grid->gridcolumn(col)->alignment());
    l->set_numberformat(p_grid->gridcolumn(col)->use_numberseparator(),p_grid->gridcolumn(col)->commadigits());
    l->set_datasource(p_grid->datasource());
    l->set_defaultvalue(p_grid->gridcolumn(col)->defaultvalue());
    l->set_columnname(p_grid->gridcolumn(col)->columnname());
    l->set_font(p_grid->hk_dsgrid::font());
    l->set_readonly((isReadOnly() || isRowReadOnly( row ) || isColumnReadOnly( col )||p_grid->gridcolumn(col)->is_readonly()));
    l->selectAll();
    l->set_gridcolumn(p_grid->gridcolumn(col));

    e=l;

	 }

	}
	if (!e)e=create_lineeditor(row,col);
	}
    }
    
    return e;

}


QWidget* hk_kdesimplegrid::create_lineeditor(int row, int col) const
{
    hk_kdelineedit* l = new hk_kdelineedit( viewport());
    l->setFrame( FALSE );
    l->setPaletteBackgroundColor(paletteBackgroundColor());
    l->set_alignment(p_grid->gridcolumn(col)->alignment());
    l->set_numberformat(p_grid->gridcolumn(col)->use_numberseparator(),p_grid->gridcolumn(col)->commadigits());
    l->set_datasource(p_grid->datasource());
    l->set_presentationdatasource(p_grid->presentationdatasource());
    l->set_defaultvalue(p_grid->gridcolumn(col)->defaultvalue());
    l->set_columnname(p_grid->gridcolumn(col)->columnname());
    l->set_font(p_grid->hk_dsgrid::font());
    l->set_readonly((isReadOnly() || isRowReadOnly( row ) || isColumnReadOnly( col )||p_grid->gridcolumn(col)->is_readonly()));
    l->selectAll();
    l->set_gridcolumn(p_grid->gridcolumn(col));
    return l;

}


void hk_kdesimplegrid::activateNextCell()
{
    nextcell();
}


void    hk_kdesimplegrid::nextcell()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::nextcell");
#endif
    if (isEditing())
        endEdit(currEditRow(),currEditCol(),true, editMode() != Editing);
    if ( currentColumn() < numCols() - 1 )
    {
        setCurrentCell( currentRow() , currentColumn()+1 );
    }
    else if ( currentRow() <= numRows() - 1)
    {
        if   (datasource()->mode()==hk_datasource::mode_insertrow) datasource()->store_changed_data();
        setCurrentCell( currentRow() + 1,0  );
    }
    clearSelection(true);

}


void    hk_kdesimplegrid::previouscell()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::previouscell");
#endif
    if (isEditing())
        endEdit(currEditRow(),currEditCol(),true, editMode() != Editing);
    if ( currentColumn() > 0 )
        setCurrentCell( currentRow() , currentColumn()-1 );
    else if ( currentRow() > 0 )
        setCurrentCell( currentRow() - 1,numCols()-1  );
    else
        setCurrentCell( 0, 0 );
}


void hk_kdesimplegrid::row_changed(int row,int col)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::row_changed");
#endif
//cerr <<"row_changed"<<endl;
   if (!datasource()) return;
   if (!datasource()->is_enabled()) return;
   if (p_grid->gridcolumn(p_currentcolumn))
    p_grid->gridcolumn(p_currentcolumn)->action_on_loosefocus();
    
    clear_vertical_header();
    bool result=true;
    if (datasource()!=NULL)
    {
        if (datasource()->is_enabled())
        {
            if ((unsigned)row<datasource()->max_rows())
                result=datasource()->goto_row(row);
            else  if (datasource()->mode()!=hk_datasource::mode_insertrow)
                datasource()->setmode_insertrow();
        }
    }
    if (!result)
    {
     setCurrentCell(p_currentrow,currentColumn());
     paint_vertical_header();
     return;
    }
    endEdit(p_currentrow,p_currentcolumn,true,false);   
    

    p_currentrow=row;
    p_currentcolumn=col;
    paint_vertical_header();
    set_statustext();
    p_grid->gridcolumn(currentColumn())->action_on_getfocus();;
//clearSelection(true);
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::row_changed ENDE");
#endif

}


void hk_kdesimplegrid::set_statustext(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::set_statustext");
#endif
    if (p_statusbar==NULL)return;
    QString status=i18n("Datasource: ");

    if (p_grid->datasource()!=NULL)
    {
        if (p_grid->datasource()->is_readonly()||p_grid->is_readonly())
        {
            status+=i18n("readonly");
        }
        else
        {
            status+=i18n("readwrite");
            status+=i18n(" Column: ");
            if (p_grid->gridcolumn(currentColumn())->column()!=NULL)
                status+=((p_grid->gridcolumn(currentColumn())->column()->is_readonly()||
                    p_grid->gridcolumn(currentColumn())->is_readonly()
                    )?
                    i18n("readonly"):
                i18n("readwrite"));
            else status+=i18n("not set");
        }
    } else status+=i18n("not set");
    p_statusbar->setText(status);
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::set_statustext ENDE");
#endif

}


void hk_kdesimplegrid::set_columnwidth(int col,int,int newwidth)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::set_columnwidth ",col);
#endif
    p_grid->set_gridcolumnwidth((unsigned)horizontalHeader()->mapToActual(col),newwidth);
}


void hk_kdesimplegrid::widget_specific_row_added()
{
#ifdef HK_DEBUG
    hkdebug ("hk_kdesimplegrid::widget_specific_row_added");
#endif
    clear_vertical_header();
    if (datasource()!=NULL)
    {
        setNumRows(datasource()->max_rows()+((datasource()->is_readonly()||p_grid->is_readonly())?0:1));
    }
    else setNumRows(1);
	widget_specific_rowheight_changes();
 paint_vertical_header();
}


void hk_kdesimplegrid::widget_specific_row_deleted()
{
#ifdef HK_DEBUG
    hkdebug ("hk_kdesimplegrid::widget_specific_row_deleted");
#endif
    clear_vertical_header();
    if (datasource()!=NULL)
    {
        setNumRows(datasource()->max_rows()+((datasource()->is_readonly()||p_grid->is_readonly())?0:1));
    }
    else setNumRows(1);
paint_vertical_header();
}


bool hk_kdesimplegrid::widget_specific_row_change(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::widget_specific_row_change");
#endif

    if (datasource()!=NULL)
    {
        long int pos=datasource()->row_position();
        setCurrentCell(pos,currentColumn());
        ensureCellVisible(pos,currentColumn());
        for (int i=0; i<numCols();i++)
            updateCell(currentRow(),i);

    }
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::widget_specific_row_change ENDE");
#endif

    return true;
}


void hk_kdesimplegrid::widget_specific_insert_mode(void)
{
#ifdef HK_DEBUG
    hkdebug ("hk_kdesimplegrid::insert_mode");
#endif
    if (datasource()==NULL||p_grid->is_readonly())return;

    unsigned int y=datasource()->max_rows();
    setCurrentCell(y,currentColumn());
    ensureCellVisible(y,currentColumn());
}


bool hk_kdesimplegrid::datasource_enable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::datasource_enable");
#endif
    hk_dsvisible::datasource_enable();
    setCurrentCell(0,0);
    ensureCellVisible(0,0);
    return true;
}

bool hk_kdesimplegrid::datasource_disable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::datasource_disable");
#endif
    cerr <<"datasource_disable()"<<endl;
    ensureCellVisible(0,0);
    widget_specific_enable_disable();
    setNumCols(1);
    setNumRows(1);
    setEnabled(false);
    return true;
}


void hk_kdesimplegrid::keyPressEvent(QKeyEvent* e)
{
#ifdef HK_DEBUG
    hkdebug ("hk_kdesimplegrid::keyPressEvent");
#endif
    if (e->key()==Key_Delete)
    {
        delete_selected_rows();
        return;
    }
    if (key_pressevent_navigation(e))return;

    p_combobox_created=false;
    QTable::keyPressEvent(e);
    if (p_combobox_created) e->accept();

    if (e->state()&ControlButton)
    {
        switch (e->key())
        {
            case Key_F :                          //Find
                p_grid->find_clicked();
                break;
            case Key_C :
	        {                       //copy
 			copy();
		}
                break;
            case Key_V :                          //paste
            {
			paste();
		break;
            }
            case Key_X :                          // cut
            {

 		cut();
		break;
            }
	    case Key_Z :
	    {
                hk_column* c=p_grid->gridcolumn(currentColumn())->column();
                if (c)
		{
		  if (c->has_changed())
		  {
		   c->set_asstring(c->asstring());
		   updateCell(currentRow(),currentColumn());
		  }
		}

			break;
            }
	    case Key_0:
	    {
		    hk_column* c=p_grid->gridcolumn(currentColumn())->column();
    		    if (c) c->set_asnullvalue();
	    }
	    default:;

        }

    }
   // ende->state()&ControlButton
   else
   {
    if (e->key()==Key_Escape && datasource())
      {
        datasource()->reset_changed_data();
	widget_specific_row_change();
      }
   }

}


bool hk_kdesimplegrid::key_pressevent_navigation(QKeyEvent* e)
{
#ifdef HK_DEBUG
    hkdebug ("hk_kdesimplegrid::key_pressevent_navigation");
#endif
    bool r=true;
    if (e->state()&ControlButton)
    {
        switch(e->key())
        {
            case Key_A:
            case Key_Left:  previouscell();
            break;
            case Key_E:
            case Key_Right: nextcell();
            break;
            case Key_Return:
                previouscell();
                break;
            case Key_Up:    if(datasource()!=0)
            {

                if (datasource()->mode()==hk_datasource::mode_insertrow) datasource()->goto_row(datasource()->max_rows()-1);
                else   datasource()->goto_previous();
            }
            break;
            case Key_Down: if(datasource()!=0)
            {
                if (currentRow()<(signed)datasource()->max_rows()-1)datasource()->goto_next();
                else
                if (currentRow()==(signed)datasource()->max_rows())
                {
                    datasource()->store_changed_data();
                }

                datasource()->setmode_insertrow();
            }
            break;
            default:    r=false;
        }
    }
    else
    {
        switch (e->key())
        {
            case Key_Return:
                nextcell();
                break;
            case Key_Down: if(datasource()!=0)
            {
                if (currentRow()==(signed)datasource()->max_rows())
                {
                    datasource()->store_changed_data();
                    datasource()->setmode_insertrow();
                    break;
                }
            }
            default: r=false;
        }
    }

    return r;

}


void hk_kdesimplegrid::column_moved(int , int from, int to)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::column_moved");
#endif
    p_grid->change_columnposition((unsigned)from,(unsigned) to);
    clearSelection();
}


void hk_kdesimplegrid::show_contextmenu(int , int , const QPoint& pos)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::show_contextmenu");
#endif
    if (datasource()==NULL)return;
    QPopupMenu* popup=new QPopupMenu(this);
    int id[8];
    
    if (runtime_only()) id[4]=-99;
    else
      id[ 4 ] = popup->insertItem( i18n( "Define columns" ) );
    
    id[ 5 ] = popup->insertItem( i18n( "Find" ) );
    popup->insertSeparator();
    id[ 3 ] = popup->insertItem( i18n( "Delete row" ) );
    hk_column* c=p_grid->gridcolumn(currentColumn())->column();
    if (c  && !c->is_readonly()&&!c->is_notnull())
    {
        id[ 6 ] = popup->insertItem( i18n( "set 'NULL' value" ),CTRL+Key_0 );
    }
    int r = popup->exec( pos );

    if (r==id[3]&&datasource()!=NULL)datasource()->delete_actualrow();
    else if (id[4]==r)
    {
        show_gridcolumndialog();
    }
    else if (id[5]==r)p_grid->find_clicked();
    else if (id[6]==r)
    if (c) c->set_asnullvalue();

        delete popup;
    return;
}


void hk_kdesimplegrid::show_gridcolumndialog(void)
{
    hk_kdegridcolumndialog* dialog=new hk_kdegridcolumndialog(p_grid,0,true);

    if (dialog->exec()==QDialog::Accepted)
    {
     p_grid->has_changed(true,forcesetting);
    }
    widget_specific_enable_disable();

    delete dialog;

}


bool hk_kdesimplegrid::eventFilter( QObject *o, QEvent *e )
{

    QWidget *editorWidget = cellWidget( currEditRow(), currEditCol() );
    if (e->type()==QEvent::KeyPress)
    {

        if ( isEditing() && editorWidget && o == editorWidget )
        {
            QKeyEvent *ke = (QKeyEvent*)e;
            if ( ( ke->state() == ControlButton  )
                && ( ke->key() == Key_Return || ke->key() == Key_Enter ) )
            {
                previouscell();
                return true;
            }

        }

    }

    bool ok=false;
//work around for a neverending event in case the user just presses a button
    if (e->type()==QEvent::KeyPress
        && o->inherits("hk_kdecombobox")
        )ok=true;

    bool res= QTable::eventFilter( o, e );

    if (ok&&p_combobox_created)return true;

// END work araound

/*if (o && o==verticalHeader() && e->type()==QEvent::MouseButtonRelease)
   {// handle resizing of a row, so that all rows will be resized, not just one
      emit signal_verticalheader_mouserelease();
     //slot_verticalheader_mouserelease();
   }*/
    return res;
}


bool hk_kdesimplegrid::delete_selected_rows(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::delete_selected_rows");
#endif
    if (!datasource()) return false;
    if (datasource()->is_readonly()) return false;
    if (isRowSelected(selection(0).topRow(),true))
    {
        bool res=datasource()->delete_rows(selection(0).topRow(),selection(0).bottomRow());
        if (res)
        {
            clearSelection();
            return true;
        }
    } else datasource()->delete_actualrow();

    return true;
}


void hk_kdesimplegrid::selection_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimplegrid::selection_changed");
#endif
}


QDragObject* hk_kdesimplegrid::dragObject()
{
    hk_griddrag* d=new hk_griddrag(marked_text(),this);
    return d;
}


void hk_kdesimplegrid::contentsDragEnterEvent(QDragEnterEvent* event)
{
    event->accept(hk_griddrag::canDecode(event));
}


void hk_kdesimplegrid::contentsDropEvent(QDropEvent* event)
{
    QString txt;
    if (hk_griddrag::decode(event,txt))
    {

        int drow=rowAt(event->pos().y());
        int dcol=columnAt(event->pos().x());
        if (numSelections()==0) setCurrentCell(drow,dcol);
        paste_tsv(txt);

    }

}


void hk_kdesimplegrid::sortColumn( int col, bool ascending, bool /*wholeRows*/)
{
    if (!datasource()) return;
    if (!datasource()->is_enabled()) return;
    hk_string colname = defaultidentifierdelimiter+p_grid->gridcolumn(col)->columnname()+defaultidentifierdelimiter;
    if (!ascending) colname+=" DESC ";
    datasource()->set_temporarysorting(colname);
    datasource()->disable();
    datasource()->set_use_temporarysorting(true);
    datasource()->enable();
    horizontalHeader()->setSortIndicator(col,ascending);

}


void hk_kdesimplegrid::print_grid(void)
{
// this is a workaround: otherwise float numbers in the postscript file
// would be created with locale dots (e.g. a comma in Germany) from Qt
    hk_string origlocale=setlocale(LC_NUMERIC,NULL);
    hk_string origmonetarylocale=setlocale(LC_MONETARY,NULL);
    int vheaderoffset=18;
    setlocale(LC_NUMERIC,"C");
    setlocale(LC_MONETARY,"C");
//workaround part 1 end
    KPrinter printer;
    if (!printer.setup(this))
    {
//workaround part 2
        setlocale(LC_NUMERIC,origlocale.c_str());
        setlocale(LC_MONETARY,origmonetarylocale.c_str());
//workaround part 2 end
        cerr <<" W A R N U N G  RETURN!"<<endl;
        return;
    }

    QPainter painter;
    painter.begin(&printer);

    QPaintDeviceMetrics metrics(&printer);

    const int topborder=50;
    const int bottomborder=50;
    const int leftborder=20;
    const int rightborder=20;
    pagenumber=1;

    list<sectionclass> verticalpages;
    list<sectionclass> horizontalpages;
    int start=0;
    int offset=0;
    int oldoffset=0;
    sectionclass newpage;
    for (int row=0;row<numRows();++row)
    {
        int rowheight=rowHeight(row);
        if (offset+rowheight>=metrics.height()-topborder-bottomborder-vheaderoffset&&offset!=0)
        {
            newpage.start=start;
            newpage.end=row-1;
            newpage.offset=oldoffset;
            verticalpages.insert(verticalpages.end(),newpage);
            oldoffset+=offset;
            offset=0;
            start=row;
        }
        offset+=rowheight;
    }
    newpage.start=start;
    newpage.end=numRows()-1;
    newpage.offset=oldoffset;
    verticalpages.insert(verticalpages.end(),newpage);
    list<sectionclass>::iterator it=verticalpages.begin();

    start=0;
    offset=0;
    oldoffset=0;
    for (int col=0;col<numCols();col++)
    {
        int colwidth=columnWidth(col);
        if (offset+colwidth>=metrics.width()-leftborder-rightborder&&offset!=0)
        {
            sectionclass newpage;
            newpage.start=start;
            newpage.end=col-1;
            newpage.offset=oldoffset;
            horizontalpages.insert(horizontalpages.end(),newpage);
            oldoffset+=offset;
            offset=0;
            start=col;
        }
        offset+=colwidth;
    }

    newpage.start=start;
    newpage.end=numCols()-1;
    newpage.offset=oldoffset;
    horizontalpages.insert(horizontalpages.end(),newpage);

    list<sectionclass>::iterator colit=horizontalpages.begin();
    it=verticalpages.begin();
    unsigned int v=1;
    colit=horizontalpages.begin();
    while (it!=verticalpages.end())
    {
        unsigned int h=1;
        colit=horizontalpages.begin();
        while (colit!=horizontalpages.end())
        {
            print_singlepage(painter,metrics,((*it)),((*colit)),topborder,bottomborder,leftborder,rightborder);
            ++pagenumber;
            ++colit;
            if (!(h==horizontalpages.size()&&v==verticalpages.size()))
            {
                printer.newPage();
            }
            ++h;
        }
        ++it;++v;
    }
    cerr<<" vor painter.end()"<<endl;

    painter.end();
    cerr<<" nach painter.end()"<<endl;
//workaround part 2
    setlocale(LC_NUMERIC,origlocale.c_str());
    setlocale(LC_MONETARY,origmonetarylocale.c_str());
//workaround part 2 end
}


void hk_kdesimplegrid::print_singlepage(QPainter& painter, QPaintDeviceMetrics&metrics,sectionclass& vertical,sectionclass& horizontal,int topborder,int bottomborder,int leftborder,int rightborder)
{
    int vheaderoffset=print_header(painter,metrics,horizontal,topborder,bottomborder,leftborder,rightborder);
    int yoffset=0;
    int xoffset=0;
    int pagewidth=metrics.width()-leftborder-rightborder;
    for (int row=vertical.start;row<=vertical.end;++row)
    {
        int rowheight=0;
        int colwidth=0;
        for (int col=horizontal.start;col<=horizontal.end;++col)
        {
            int colpos=columnPos(col);
            colwidth=columnWidth(col);

            int rowpos=rowPos(row);
            rowheight=rowHeight(row);

            rowpos-=vertical.offset;
            colpos-=horizontal.offset;
            painter.translate(colpos+leftborder,rowpos+topborder+vheaderoffset);
            paintCell(&painter,row,col,QRect(colpos,rowpos,(colpos+colwidth>pagewidth?pagewidth-colpos:colwidth),rowheight),false,colorGroup());
            painter.translate( -colpos-leftborder, -rowpos -topborder -vheaderoffset);
            xoffset+=colwidth;
        }
        yoffset+=rowheight;
    }
    print_frame(painter,metrics,topborder,bottomborder,leftborder,rightborder);

}


void hk_kdesimplegrid::print_frame(QPainter& painter,QPaintDeviceMetrics& metrics,int topborder,int bottomborder,int leftborder,int rightborder)
{
    QPen pen( painter.pen() );
//	painter.setPen( colorGroup().mid() );
    painter.drawRect( leftborder, topborder,  metrics.width()-leftborder-rightborder ,metrics.height()-topborder-bottomborder);
    painter.setPen( pen );
    QString pgnr=i18n("Page")+"-"+QString::number(pagenumber)+"-";

//	painter.drawText(metrics.width()/2,metrics.height()-bottomborder/2,pgnr);

    painter.drawText(leftborder,metrics.height()-bottomborder/2,metrics.width()-leftborder-rightborder,bottomborder,Qt::AlignRight,pgnr);
    hk_datetime dt;
    dt.set_now();
    painter.drawText(leftborder,metrics.height()-bottomborder/2,metrics.width()-leftborder-rightborder,bottomborder,Qt::AlignLeft,QString::fromLocal8Bit(dt.datetime_asstring().c_str()));
    QString tablename=(datasource()->type()==hk_datasource::ds_query?i18n("Query: "):i18n("Table: "))+QString::fromLocal8Bit(datasource()->name().c_str());
    painter.drawText(leftborder,topborder/2,metrics.width()-leftborder-rightborder,topborder,Qt::AlignRight,tablename);

    QString databasename=i18n("Database: ")+QString::fromLocal8Bit(datasource()->database()->name().c_str());
    painter.drawText(leftborder,topborder/2,metrics.width()-leftborder-rightborder,topborder,Qt::AlignLeft,databasename);

}


int  hk_kdesimplegrid::print_header(QPainter& painter,QPaintDeviceMetrics&metrics,sectionclass& horizontal,int topborder,int /*bottomborder*/,int leftborder,int rightborder)
{
    int pagewidth=metrics.width()-leftborder-rightborder;
    int rowheight=18;
    for (int col=horizontal.start;col<=horizontal.end;++col)
    {
        int colpos=columnPos(col);
        painter.translate(colpos+leftborder-horizontal.offset,topborder);
        int colwidth=columnWidth(col);
                                                  // columnWidth(col);
        int w = (colpos+colwidth-horizontal.offset>pagewidth?pagewidth-colpos+horizontal.offset:colwidth);
        int h = rowheight;
        int x2 = w - 1;
        int y2 = h - 1;
        painter.fillRect(0,0,x2,y2,colorGroup().brush(QColorGroup::Button));
        painter.drawLine( x2, 0, x2, y2 );
        painter.drawLine( 0, y2, x2, y2 );
        painter.drawText(2,3,w-7,
            rowheight-3,Qt::AlignLeft
            ,QString::fromLocal8Bit (p_grid->gridcolumn(col)->displayname().size()==0?
            p_grid->gridcolumn(col)->columnname().c_str():
        p_grid->gridcolumn(col)->displayname().c_str()));
        painter.translate(-colpos-leftborder+horizontal.offset,-topborder);
    }
    //cerr <<endl<<endl<<endl;
    return rowheight;
}


QString hk_kdesimplegrid::marked_text(void)
{
  if (numSelections()==0)
    return QString::fromLocal8Bit(p_grid->gridcolumn(currentColumn())->value_at(currentRow()).c_str());

  QTableSelection s=selection(0);
  QString result;
  for (int r=s.topRow();r<=s.bottomRow();++r)
   {
   for (int c=s.leftCol();c<=s.rightCol();++c)
    {
    hk_string d=p_grid->gridcolumn(c)->value_at(r);
    d=replace_all("\\",d,"&bs;");
    d=replace_all("\t",d,"\\t");
    d=replace_all("\n",d,"\\n");

      result+=QString::fromLocal8Bit(d.c_str());
      if (c!=s.rightCol()) result+="\t";
    }
   if (r<s.bottomRow()) result+="\n";
   }
  return result;
}


void hk_kdesimplegrid::paste_tsv(const QString& txt)
{//txt contains the whole clipboard or drag data
 hk_string t=txt.local8Bit().data();
 if (t.size()==0) return;
 //hk_column* c=p_grid->gridcolumn(currentColumn())->column();
 int maxrow=-1;
 int maxcol=-1;
 int startcol=currentColumn();
 int startrow=currentRow();
 if (numSelections()>0)
  {
   QTableSelection s=selection(0);
   if (s.leftCol()!=s.rightCol()||s.topRow()!=s.bottomRow())//only use selections with more than 1 cell
   {
    maxrow=s.bottomRow();
    maxcol=s.rightCol();
    startcol=s.leftCol();
    startrow=s.topRow();
   } //else cerr<<"single cell selection!"<<endl;
  }

  setCurrentCell(startrow,startcol);
  int countcol=0;
  int countrow=0;
  unsigned int txtposition=0;
  hk_string value;
  while (txtposition<=t.size())
  {
  hk_string c(1,t[txtposition]);
  if (c=="\t"||c=="\n"||txtposition==t.size())
    {
     value=replace_all("\\t",value,"\t");
     value=replace_all("\\n",value,"\n");
     value=replace_all("&bs;",value,"\\");
     p_grid->gridcolumn(currentColumn())->column()->set_asstring(value);
      value="";
      updateCell(currentRow(),currentColumn());
      if (c=="\t")
         {
	 ++countcol;
	 if (currentColumn()+1<numCols() && (maxcol==-1 ||(maxcol!=-1&&currentColumn()+1<=maxcol)))
	   setCurrentCell(currentRow(),currentColumn()+1);
	 else
	   {
        	countcol=0;
		++countrow;
	 	datasource()->store_changed_data();
                if (maxrow>-1&&currentRow()+1>maxrow)return;
	 	setCurrentCell(currentRow()+1,startcol);
		while (txtposition<t.size()&&c.assign(1,t[txtposition])!="\n") ++txtposition;

	   }

	 }
      else
      { //c=="\n" or EOF
        countcol=0;
	++countrow;
	 datasource()->store_changed_data();
	 if (maxrow>-1&&currentRow()+1>maxrow)return;
	 if (txtposition!=t.size()) setCurrentCell(currentRow()+1,startcol);
      }

    } else value+=c;

  ++txtposition;
  }

}


void hk_kdesimplegrid::slot_mouse_clicked(void)
{  
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       )
   {    
          p_grid->action_on_click();
	  p_grid->gridcolumn(currentColumn())->action_on_click();
   }	  
}

void hk_kdesimplegrid::slot_mouse_doubleclicked(void)
{
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       )
   {
          p_grid->action_on_doubleclick();
  	  p_grid->gridcolumn(currentColumn())->action_on_doubleclick();

   }
}


void hk_kdesimplegrid::focusOutEvent ( QFocusEvent * e )
{
action_on_loosefocus();
 if (p_grid&&p_grid->part())
   emit signal_outfocus(p_grid->part(),e);
}

void hk_kdesimplegrid::focusInEvent ( QFocusEvent * )
{
action_on_getfocus();

if (p_grid&&p_grid->part())
   emit signal_infocus(p_grid->part());
updateCell(currentRow(),currentColumn());
}


void hk_kdesimplegrid::copy(void)
{
	         QString value=marked_text();
		 hk_griddrag* d=new hk_griddrag(value);
		 d->setSubtype("plain");
                 QApplication::clipboard()->setData(d);

}


void hk_kdesimplegrid::paste(void)
{
                QString txt;
                if (hk_griddrag::decode(QApplication::clipboard()->data(),txt))
                {
		  paste_tsv(txt);

                }

}

void hk_kdesimplegrid::cut(void)
{
                copy();
                hk_column* c=p_grid->gridcolumn(currentColumn())->column();
                if (c)
                {
		 if (numSelections()==0)
		 {
                      c->set_asstring("",true);
                    updateCell(currentRow(),currentColumn());
                 }
		 else
		 {
  			QTableSelection s=selection(0);
  			for (int r=s.topRow();r<=s.bottomRow();++r)
   			{
			datasource()->goto_row(r);
   			for (int c=s.leftCol();c<=s.rightCol();++c)
    			{
      				p_grid->gridcolumn(c)->column()->asstring("");
                    		updateCell(r,c);
    			}
			}
                }
  }


}




void hk_kdesimplegrid::slot_verticalheader_resized(int section,int /*oldsize*/,int newsize)
{
if (p_hk_kdesimplegridprivate->autoresizeverticalheader) return;
p_hk_kdesimplegridprivate->p_resizeverticalheader=true;
p_hk_kdesimplegridprivate->newsize=newsize;
 //cerr <<"resize vertical section: "<<section<<" newsize=" <<newsize<<endl;
slot_verticalheader_mouserelease();
ensureCellVisible(section,currentColumn());
}

void hk_kdesimplegrid::slot_verticalheader_mouserelease(void)
{
if (!p_hk_kdesimplegridprivate->p_resizeverticalheader) return;
p_grid->set_rowheight(p_hk_kdesimplegridprivate->newsize);
p_hk_kdesimplegridprivate->p_resizeverticalheader=false;
}

void hk_kdesimplegrid::widget_specific_rowheight_changes(void)
{//cerr<<"hk_kdesimplegrid::widget_specific_rowheight_changes "<<p_hk_kdesimplegridprivate->newsize<<endl;
//disabled because QTable behaves terrible for large tables
//return;

p_hk_kdesimplegridprivate->autoresizeverticalheader=true;
int begin=rowAt(contentsY());
slot_content_moving(0,begin);
p_hk_kdesimplegridprivate->autoresizeverticalheader=false;
}



void hk_kdesimplegrid::slot_content_moving(int /*x*/,int y)
{
int begin=rowAt(y);
int end=rowAt(y+QTable::height());
if (end<begin||end>numRows()) end=numRows();
if (end+500>numRows()) end=numRows();
if (end<numRows()+100) end+=100;

cerr <<"slot_content_moving b="<<begin<<" e="<<end<<endl;
 for (int i=begin;i<=end;++i)
   {
     if (rowHeight(i)!=p_grid->rowheight())
       setRowHeight(i,p_grid->rowheight());
   }


}


hk_kdegrid* hk_kdesimplegrid::kdegrid() const
{
 return p_grid;
}


void  hk_kdesimplegrid::widget_specific_tooltip_changed(void)
{
 QToolTip::add(this,QString::fromLocal8Bit (tooltip().c_str()));
}


void hk_kdesimplegrid::clear_vertical_header(void)
{
   if (datasource() &&!datasource()->is_readonly()&&!p_grid->is_readonly())
   
     verticalHeader()->setLabel(datasource()->max_rows(),"*");
   QString r;
    p_currentrow==datasource()->max_rows()?r="*":r.setNum(p_currentrow+1);
    verticalHeader()->setLabel(p_currentrow,no_image,r);

}

void hk_kdesimplegrid::paint_vertical_header(void)
{
   if (datasource() &&!datasource()->is_readonly()&&!p_grid->is_readonly())
        verticalHeader()->setLabel(datasource()->max_rows(),"*");
   QString r;
    p_currentrow==datasource()->max_rows()?r="*":r.setNum(p_currentrow+1);
    verticalHeader()->setLabel(p_currentrow,arrow_image,r);
}


