// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.17 $

#include "hk_kdedriverdialog.h"
#include "hk_kdedriverdialog.moc"
#include <list>
#include <klocale.h>
#include <hk_kdemessages.h>
#include <hk_classes.h>
#include <hk_drivermanager.h>

#ifndef DIRVIEW_H
#define DIRVIEW_H

#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <kapplication.h>
#include <kconfig.h>

class Directory: public QListViewItem
{
    public:
        Directory( QListView * parent );
        Directory( Directory * parent, const char * filename );

        QString  text( int column ) const;

        QString fullName();

        void setOpen( bool );
        void setup();

    private:
        QFile f;
        Directory * p;
        bool readable;
};
#endif

hk_kdedriverdialog::hk_kdedriverdialog(QWidget *parent, const char *name) : QDialog(parent,name,true)

{
//        p_connection=NULL;
    driverlist =new QListBox (this);
    ok_button  =new QPushButton(this);
    exit_button=new QPushButton(this);
    label= new QLabel(this);
    directorylist = new QListView(this);
    p_originaldriverpath=hk_drivermanager::path();
    label->setText(i18n("Found database drivers:"));
    setCaption(i18n("SQL Driver Selection"));
    int top = 30;
    int left= 20;
    int buttonwidth=100;
    int buttonheight=30;
    int listwidth=150;
    int vspace=20;
    int offset=0;
    int hspace=20;
    int add=buttonheight+vspace;
    int directorylistwidth=200;
    int buttonleft=left+directorylistwidth+listwidth+2*hspace;
    int listheight=200;
    label->setGeometry(left+directorylistwidth+hspace,0,listwidth+hspace+buttonwidth,buttonheight);
    ok_button->setGeometry(buttonleft,top+offset,buttonwidth,buttonheight);
    offset+=add;
    exit_button->setGeometry(buttonleft,top+offset,buttonwidth,buttonheight);
    offset+=add;
    directorylist->addColumn(i18n("Directory"),-1);
    driverlist->setGeometry(left+directorylistwidth+hspace,top,listwidth,listheight);
    directorylist->setGeometry(left,top,directorylistwidth,listheight);
    Directory* dir = new Directory(directorylist);

    Directory* dir2=NULL;

    dir2=new Directory(dir,QString::fromLocal8Bit (hk_drivermanager::path().c_str()));
    directorylist->setSelected(dir2,true);
    dir2=new Directory(dir,"/");

    directorylist->setFocus();
    setGeometry(0,0,buttonleft+hspace+buttonwidth,top+listheight+vspace);

    ok_button->setText(i18n("Connect"));
    exit_button->setText(i18n("Exit"));
    connect(ok_button,SIGNAL(clicked()),this,SLOT(ok_clicked()));
    connect(exit_button,SIGNAL(clicked()),this,SLOT(exit_clicked()));
    connect(directorylist,SIGNAL(selectionChanged (QListViewItem*)),this,SLOT(directory_changed(QListViewItem*)));
    connect(driverlist,SIGNAL(doubleClicked(QListBoxItem*)),this,SLOT(ok_clicked()));
    directory_changed(dir2);
    driverlist->setFocus();
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("Driverdialog");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);

}


hk_kdedriverdialog::~hk_kdedriverdialog()
{
    delete ok_button;
    delete exit_button;
    delete driverlist;
    delete label;
}


void hk_kdedriverdialog::ok_clicked(void)
{
    if (driverlist->currentItem()<0)
    {
        hk_class::show_warningmessage(hk_class::hk_translate("Please select a driver"));
        return;
    }
    QString d=driverlist->text(driverlist->currentItem());
    p_drivername=(d.isNull()?"":d.local8Bit().data());
    
    KConfig* c=kapp->config();
    c->setGroup("Driverdialog");
    c->writeEntry("Geometry",geometry());
    
    
    accept();

}


void hk_kdedriverdialog::exit_clicked(void)
{
    hk_drivermanager::set_path(p_originaldriverpath);
    reject();

}


void  hk_kdedriverdialog::directory_changed(QListViewItem *item )
{
// cout <<" hk_kdedriverdialog::directory_changed"<<endl;
    driverlist->clear();
    ok_button->setEnabled(false);
    hk_drivermanager::set_path(((Directory*)item)->fullName().local8Bit().data());
    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    for(it=drv->begin();it!=drv->end();it++)
    {
        ok_button->setEnabled(true);
        driverlist->insertItem(QString::fromLocal8Bit ((*it).c_str()));
    }

    driverlist->repaint(true);

}


/****************************************************************************
 ** $Id: hk_kdedriverdialog.cpp,v 1.17 2005/03/11 22:59:10 knorr Exp $
 **
 ** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
 **
 ** This file is part of an example program for Qt.  This example
 ** program may be used, distributed and modified without limitation.
 **
 *****************************************************************************/

Directory::Directory( Directory * parent, const char * filename )
: QListViewItem( parent ), f(filename )
{
    p = parent;
    readable = TRUE;
}


Directory::Directory( QListView * parent )
: QListViewItem( parent ), f("DRIVER PATH")
{
    p = 0;
    readable = TRUE;

    setOpen(true);
}


void Directory::setOpen( bool o )
{
    if ( o && !childCount() )
    {
        QString s( fullName() );
        QDir thisDir( s );
        if ( !thisDir.isReadable() )
        {
            readable = FALSE;
            return;
        }

        const QFileInfoList * files = thisDir.entryInfoList();
        if ( files )
        {
            QFileInfoListIterator it( *files );
            QFileInfo * f;
            while( (f=it.current()) != 0 )
            {
                ++it;
                if ( f->fileName() == "." || f->fileName() == ".." )
                    ;
                else
                if ( f->isDir() )
                    new Directory( this, f->fileName() );
            }
        }

    }

    QListViewItem::setOpen( o );
}


void Directory::setup()
{
    setExpandable( TRUE );
    QListViewItem::setup();
}


QString Directory::fullName()
{
    QString s;
    if ( p )
    {
        s = p->fullName();
        s.append( f.name() );
        if (s.length()>0)
        {
            if (s[s.length()-1]!='/') s.append( "/" );
        }
    }
    else
    {
//  s = "/";
    }

    return s;
}


QString Directory::text( int column ) const
{
    if ( column == 0 )
        return f.name();
    else if ( readable )
        return "Directory";
    else
        return "Unreadable Directory";
}
