/***************************************************************************
                          kfocuslogentriesview.h  -  description
                             -------------------
    begin                : Sun Aug 19 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSLOGENTRIESVIEW_H
#define KFOCUSLOGENTRIESVIEW_H

#include <qwidget.h>
#include <qlistbox.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>

class QLayout;
class KFMLogBook;
class KFMLog;

class KFVLog;

/**View of the entries in a log
  *@author Jeffrey Yu
  */

class KFVLogBook : public QWidget  {
   Q_OBJECT
public: 
	KFVLogBook(QWidget *parent=0, const char *name=0);
	~KFVLogBook();
	
  /** Retrieve the current logBook for this view */
  KFMLogBook* logBook() const;
  /** Set the logBook for this view */
  void logBook(KFMLogBook* logBook);

private: // Private attributes
  /** Listbox to show the dates of entries in the logBook */
  QListBox* lbEntries_;
  /** Log to display in the view */
  KFMLogBook* logBook_;
  /** MultiLineEdit for showing the body of the current entry */
  QMultiLineEdit* mleBody_;

  /** Pushbutton to create a new entry */
  QPushButton* pbNewEntry_;
	/** Status of the new-entry pushbutton */
  bool pbNewEntryEnabled_;
  	
  /** Pushbutton to delete an entry */
  QPushButton* pbDeleteEntry_;
  /** Status of the delete-entry pushbutton */
  bool pbDeleteEntryEnabled_;

  KFVLog* vLog_;
  	
  /** Status of the logBook widgets */
  bool logBookWidgetsOn_;

private: // Private methods
  /** Make the widgets in this view */
  void createWidgets();
  void createLeftWidgets(QLayout* lParent);

  /** Check the status of the logBook widgets */
  bool logBookWidgetsOn() const;
  /** Change the status of the logBook widgets */
  void logBookWidgetsOn(const bool on);

  /** Clear out the contents of the entries listbox */
  void unloadEntriesListBox();
  /** Load up the entries list box with entry dates */
  void loadEntriesListBox();

  /** Read the state of the new-entry pushbutton */
  bool pbNewEntryEnabled() const;
  /** Change the state of the new-entry pushbutton */
  void pbNewEntryEnabled(bool enabled);

  /** Read the state of the delete-entry pushbutton */
  bool pbDeleteEntryEnabled() const;
  /** Change the state of the delete-entry pushbutton */
  void pbDeleteEntryEnabled(bool enabled);

private slots: // Private slots
  /** Slot to receive currentChanged from the entries listbox */
  void onEntriesListBoxCurrentChanged(QListBoxItem* item);
  /** Slot for when the logBook adds an entry */
  void onLogBookEntryAdded(KFMLog* entry);
  /** Slot for when the logBook removes an entry */
  void onLogBookEntryRemoved(KFMLog* entry, int pos);
  /** Slot to receive clicked signal from the new-entry pushbutton */
  void onNewEntryPushButtonClicked();
  /** Slot to receive clicked signal from the delete-entry pushbutton */
  void onDeleteEntryPushButtonClicked();
};

#endif
