/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2004 by Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef KBPROJECTMANAGER_H
#define KBPROJECTMANAGER_H

#include <qstring.h>
#include <qptrlist.h>

#include "kbproject.h"

namespace KBabel
{

    class ProjectManager
    {
	public:
	    static Project::Ptr open( const QString& file );
	    static void close( Project::Ptr project );
	    static Project::Ptr create();
	    
	    friend class Project;
	private:
	    static void remove (Project*);
	    static QPtrList<Project> p_list;
    };

}

#endif // KBPROJECTMANAGER_H
