/* Copyright (C) 2002 Philippe Fremy <pfremy@kde.org>
   Strongly inspired by other KPart applications and tutorials.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#ifndef VIMPART_FACTORY_H
#define VIMPART_FACTORY_H

#include <kparts/factory.h>

class KInstance;
class KAboutData;

class VimPartFactory : public KParts::Factory
{
	Q_OBJECT
public:
    VimPartFactory();
    virtual ~VimPartFactory();
	
	KParts::Part *createPartObject (QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name, const char *classname, const QStringList &args );
	
	static const KAboutData *aboutData(); 
    static KInstance* instance();

private:

    static KInstance *s_instance;
    static KAboutData *s_aboutData;
};

#endif // VIMPART_FACTORY_H
