/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                                   *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 /*
  * Last modified: $Date: 2005/02/02 10:08:26 $ by $Author: juergenk $
  */
 
#ifndef PLAYLISTIMPORT_H
#define PLAYLISTIMPORT_H

/**
Static methods for playlist import.

@author Jürgen Kofler
*/

class MRL;
class QTime;
class QString;
class QWidget;

class PlaylistImport
{
public:

   static bool kaffeine(const QString&, MRL::List&);
   static bool noatun(const QString&, MRL::List&);
   static bool m3u(const QString&, MRL::List&);
   static bool pls(const QString&, MRL::List&);
   static bool ram(const MRL&, MRL::List&, QWidget*);
   static bool asx(const QString&, MRL::List&);
   static bool smil(const QString&, const MRL&, MRL::List&);
   /* helper */
   static QTime stringToTime(const QString&);
};

#endif
