/***************************************************************************
                          scandialog.h  -  description
                             -------------------
    begin                : Mon Mar 22 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:25 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCANDIALOG_H
#define SCANDIALOG_H

#include <qtimer.h>
#include <qprogressbar.h>
#include <qlabel.h>

#include <kled.h>

#include "kgradprogress.h"
#include "scandialogui.h"
#include "channeldesc.h"

class DVBsi;
class DvbStream;



class ScanDialog : public ScanDialogUI
{
	Q_OBJECT
	
public:

	ScanDialog( DvbStream *d, QPtrList<ChannelDesc> *ch, QSize size, QString src );
	~ScanDialog();

	QPtrList<Transponder> transponders;
	QPtrList<ChannelDesc> *chandesc;

private slots:

	void scan( bool b );
	void checkNewChannel();
	void setLock( bool on );
	void siEnded( bool b );
	void addFiltered();
	void addSelected();
	void setProgress();
	void pop( QListViewItem *it, const QPoint &pos, int col );
	void deleteAll();
	void newChannel();
	void deleteChannel( QString name );
	void deleteChannel();
	
private:

	bool getTransData();
	bool edit( QString &name, QPixmap &pix );
	void working( bool b );
	void parseTp( QString s, fe_type_t type, QString src );
	void addFound( ChannelDesc *chan, bool scan );

	DvbStream *dvb;
	KGradProgress *snr, *signal;
	QProgressBar *progress;
	KLed *lock;
	DVBsi *dvbsi;
	QTimer checkTimer, progressTimer;
	int nChannels;
	QPixmap tvPix, raPix, tvcPix, racPix;
	int ntv, nradio;
	QLabel *progressLab;
	fe_type_t dvbType;
	QString sourcesPath;
};
#endif
