/***************************************************************************
                          kevents.cpp  -  description
                             -------------------
    begin                : Wed Jan 7 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:25 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qfile.h>
#include <qdir.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qwhatsthis.h>

#include <klocale.h>
#include <kiconloader.h>
 
#include "kevents.h"
#include "channeldesc.h"
#include "dvbevents.h"



KEvents::KEvents( QPtrList<ChannelDesc> *chans, DVBevents *ev, QWidget *parent, QSize size ) : QDialog( parent )
{
	dvbEvents = ev;
	channels = chans;

	setCaption( i18n("EPG") );

	QGridLayout *grid = new QGridLayout( this, 1, 1, 11, 6, "grid");
	QHBoxLayout *hbox = new QHBoxLayout( 0, 0, 6, "hbox" );
	
	resetBtn = new KPushButton( i18n("Refresh"), this );
	hbox->addWidget( resetBtn );
	currentNextBtn = new KPushButton( i18n("Current/Next"), this );
	hbox->addWidget( currentNextBtn );
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	hbox->addItem( spacer );
	grid->addLayout( hbox, 0, 0 );

	listView = new KListView( this, "listView" );
	listView->addColumn( i18n( "Channel" ) );
	listView->addColumn( i18n( "Begin" ) );
	listView->addColumn( i18n( "Duration" ) );
	listView->addColumn( i18n( "Title" ) );
	listView->setResizePolicy( KListView::AutoOneFit );
	listView->setAllColumnsShowFocus( TRUE );
	listView->setFullWidth( TRUE );
	grid->addWidget( listView, 1, 0 );
	grid->setRowStretch( 1, 4 );

	textBrow = new QTextBrowser( this );
	grid->addWidget( textBrow, 2, 0 );
	grid->setRowStretch( 2, 2 );

	KIconLoader *icon = new KIconLoader();
	resetBtn->setGuiItem( KGuiItem(i18n("Refresh"), icon->loadIconSet("reload", KIcon::Small) ) );
	currentNextBtn->setGuiItem( KGuiItem(i18n("Current/Next"), icon->loadIconSet("toggle_log", KIcon::Small) ) );

	new KListViewItem( (QListView*)listView, "Une chaine", "99/99/99  99:99 9999", "99:99 99", "un titre de programme" );

	resize( size );
	if ( dvbEvents ) {
		connect( resetBtn, SIGNAL( clicked() ), this, SLOT( reset() ) );
		connect( currentNextBtn, SIGNAL( clicked() ), this, SLOT( setCurrentNext() ) );
		connect( &checkTimer, SIGNAL( timeout() ), this, SLOT( checkNewEvent() ) );
		connect( listView, SIGNAL( mouseButtonClicked(int,QListViewItem*,const QPoint&,int) ),
			this, SLOT(mouseClickedSlot(int,QListViewItem*,const QPoint&,int)) );
	}
	setMode( 1 );
}



void KEvents::mouseClickedSlot( int btn, QListViewItem *it, const QPoint &p, int c )
{
	int i=c;
	QPoint pt=p;
	QString s;
	EventsItem *ei=0;

	for ( i=0; i<(int)evitem.count(); i++ ) {
		if ( evitem.at(i)->item==it ) {
			ei = evitem.at(i);
			break;
		}
	}

	if ( !ei ) return;
	switch ( btn ) {
		case Qt::RightButton : {
			QPopupMenu *pop = new QPopupMenu();
			pop->insertItem( i18n("View all programs"), 1 );
			pop->insertSeparator();
			pop->insertItem( i18n("Add to timers"), 2 );
			if ( ei->event->running==4 ) pop->setItemEnabled( 2, false );
			i = 0;
			i = pop->exec( QCursor::pos() );
			switch ( i ) {
				case 0 :
					break;
				case 1 :
					setMode( 2, it->text(0) );
					break;
				case 2 : 
					emit addTimer( it->text(0), it->text(3), ei->event->startDateTime, ei->event->duration );
					break;
			}
			delete pop;
			break;
		}
		case Qt::LeftButton : {
			s = "<qt><h3><font color=\"darkblue\">";
			s = s+it->text(0)+"</font></h3>";
			if ( ei->event->title!="" ) {
				s = s+"<b><font color=\"darkgreen\"><big>";
				s = s+ei->event->title;
				s = s+"</big></font></b><br>";
			}
			if ( ei->event->subtitle!="" ) {
				s = s+"<b><font color=\"#A69631\">";
				s = s+ei->event->subtitle;
				s = s+"</font></b><br>";
			}
			s = s+"<br><font color=\"darkred\">";
			s = s+ei->event->startDateTime.toString()+"<br>";
			s = s+ei->event->duration.toString("hh:mm");
			s = s+"</font><br><br>";
			for ( i=0; i<(int)ei->event->shortEvents.count(); i++ ) {
				s = s + ei->event->shortEvents.at(i)->name;
				if (ei->event->shortEvents.at(i)->name!="" && ei->event->shortEvents.at(i)->text!="") {
					s = s + " : ";
				}
				s = s + ei->event->shortEvents.at(i)->text;
				s = s + "<br>";
			}
			for ( i=0; i<(int)ei->event->extEvents.count(); i++ ) {
				s = s+ *ei->event->extEvents.at(i);
			}
			s = s+"</qt>";
			textBrow->setText( s );
			break;
		}
	}
}



void KEvents::setCurrentNext()
{
	setMode( 1 );
}



void KEvents::setMode( int m, QString name )
{
	int i;
	
	mode = m;
	reset();
	if ( name!="" ) {
		currentNextBtn->show();
		for ( i=0; i<(int)channels->count(); i++ ) {
			if ( channels->at(i)->name==name ) {
				chan = channels->at(i);
				break;
			}
		}
	}
	else {
		chan = 0;
		currentNextBtn->hide();
	}
}



void KEvents::reset()
{
	if ( checkTimer.isActive() ) checkTimer.stop();
	listView->clear();
	evitem.clear();
	nEvents = 0;
	checkTimer.start( 100 );
}



void KEvents::checkNewEvent()
{
	int i, j;
	KListViewItem *itt=0;
	EventsItem *ei=0;
	QString s, t, channel, begin, duration, title;
	bool ret;
	EventDesc *desc;

	for ( j=nEvents; j<(int)dvbEvents->events.count(); j++ ) {
		nEvents++;
		desc = dvbEvents->events.at(j);
		if ( mode==1 && desc->tid>0x4f ) continue;
		if ( mode==2 ) {
			if ( !chan ) continue;
			if ( desc->sid!=chan->sid || desc->tsid!=chan->tp.tsid ) continue;
			channel = chan->name;
		}
		else {
			ret = true;
			for ( i=0; i<(int)channels->count(); i++ ) {
				if ( desc->sid==channels->at(i)->sid && desc->tsid==channels->at(i)->tp.tsid ) {
					channel = channels->at(i)->name;
					ret = false;
					break;
				}
			}
			if ( ret ) continue;
		}
		begin = desc->startDateTime.toString("dd/MM/yy  hh:mm");
		duration = desc->duration.toString("hh:mm");
		title = desc->title;
		if ( title=="" ) continue;
		ei = new EventsItem();
		if ( !ei ) continue;
		itt = new KListViewItem( (QListView*)listView, channel.latin1(), begin, duration, title.latin1() );
		if ( !itt ) {
			delete ei;
			continue;
		}
		ei->event = desc;
		ei->item = itt;
		evitem.append( ei );
	}
}



KEvents::~KEvents()
{
	if ( checkTimer.isActive() ) checkTimer.stop();
}
