/***************************************************************************
                          dvbconfig.h  -  description
                             -------------------
    begin                : Wed Apr 21 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/15 18:27:00 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBCONFIG_H
#define DVBCONFIG_H

#include <qspinbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qtoolbutton.h>

#include <kdialogbase.h>
#include <kpushbutton.h>
#include <kconfig.h>
#include <kio/job.h>
#include <kprogress.h>

#include <linux/dvb/frontend.h>

using namespace KIO;



class MSpinBox : public QSpinBox
{
	Q_OBJECT

public:

	MSpinBox( QWidget *parent, int devNum );

public slots:

	void slotValueChanged( int value );

signals:

	void signalValueChanged( int value, int devNum );

private:

	int deviceNumber;
};



class Device
{

public:

	Device( int num, fe_type_t t, QString n );

	int adapter;
	fe_type_t type;
	QString name;
	QString source;
};



class DVBconfig : public QObject
{
	Q_OBJECT

public:

	DVBconfig( KConfig* conf, QString dvbConf );
	~DVBconfig() {};
	void readConfig();
	void saveConfig();
	void startup();
	static bool haveDvbDevice();
	bool loadDvbData( QWidget *parent );
	bool localData();
	QStringList getSourcesList( int devNum );
	bool haveData();
	bool firstRun();

	KConfig *config;
	QString recordDir, shiftDir;
	int beginMargin, endMargin, format, instantDuration;
	QSize epgSize, scanSize, timerSize;
	QPtrList<Device> devList;
	QString dvbConfigDir;

private:

	KProgressDialog *downProgress;
	bool downloadFinished;

private slots:

	void setDownloadResult( KIO::Job *job );
	void setDownloadPercent( KIO::Job *job, unsigned long percent );
};



class DvbConfigDialog : public KDialogBase
{
	Q_OBJECT

public:

	DvbConfigDialog( DVBconfig *dc, QWidget *parent );
	~DvbConfigDialog();
	void setSource( QComboBox *box, QString s, int sat );

	QLineEdit *recordDirLe, *shiftDirLe;
	QSpinBox *beginSpin, *endSpin, *instantDurationSpin;
	QSpinBox *satNumber[4];
	QComboBox *sat0[4];
	QComboBox *sat1[4];
	QComboBox *sat2[4];
	QComboBox *sat3[4];
	QComboBox *formatComb;
	KPushButton *updateBtn;
	QToolButton *recordDirBtn, *shiftDirBtn;
	QFrame *miscPage, *recordPage, *dvbPage[4];
	DVBconfig *dvbConfig;

private slots:

	void setRecordDir();
	void setShiftDir();
	void satNumberChanged( int value, int devNum );
	void downloadData();

protected slots:

	virtual void accept();
};

#endif
