/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 */

/* syncmal.h
 *
 * J-Pilot plugin callback functions by Jason Day, jasonday@worldnet.att.net
 * http://jasonday.home.att.net
 */

#ifndef __SYNCMAL_H__
#define __SYNCMAL_H__

#include <stdio.h>
#include <stdarg.h>

#define PREFS_FILE "syncmal.rc"

#define SMPREF_SYNC_WHEN       0
#define SMPREF_USE_PROXY       1
#define SMPREF_PROXY_ADDRESS   2
#define SMPREF_PROXY_PORT      3
#define SMPREF_PROXY_USERNAME  4
#define SMPREF_PROXY_PASSWORD  5
#define SMPREF_USE_SOCKS       6
#define SMPREF_SOCKS_ADDRESS   7
#define SMPREF_SOCKS_PORT      8
#define SMPREF_LAST_SYNC       9

/* Sync when constants */
#define EVERY_SYNC            10
#define HOURLY                11
#define MORNING_AND_AFTERNOON 12
#define DAILY                 13
#define DISABLED              14

/* Sync when button constants */
#define EVERY_SYNC_BUTTON              100
#define HOURLY_BUTTON                  101
#define MORNING_AND_AFTERNOON_BUTTON   102
#define DAILY_BUTTON                   103
#define DISABLED_BUTTON                104

#define NUM_SMPREFS 10

#endif /* __SYNCMAL_H__ */
