/*
 *      IT-HE Generic Support Library, (C) 2000 IT-HE Software
 */

#ifndef __ITHE_SUPPORT_LIB__
#define __ITHE_SUPPORT_LIB__

#include <stdio.h>            // Just in case
#include <time.h>

// Enable full memory debugging with Fortify (very slow!)
//#define FORTIFY

// Are we a Unix-like system?
#if defined (__linux__) || defined (__BEOS__)
#define __SOMEUNIX__
#endif

#ifndef _WIN32
#include <signal.h>
#endif


// Defines that may need changing

#define MAX_LINE_LEN 4096	// Maximum line length for string processing
//#define LOG_MEM		// Help find leaks


// Are we on Windows?  If so we need to help it
#ifdef _WIN32
	typedef __int64 qword;
	typedef unsigned __int64 uqword;
	#define F_OK 0
	#define X_OK 1
	#define W_OK 2
	#define R_OK 4

	#define BYTE_ORDER 1
	#define LITTLE_ENDIAN 1
	#define BIG_ENDIAN 2
#else
	typedef long long qword;
	typedef unsigned long long uqword;
#endif


#ifdef __cplusplus
extern "C" {
#endif

#ifndef NO_FORTIFY
#include "fortify.h"          // Fortify is a memory-leak detector
#endif

//
//      Log and console
//

extern char *ithe_get_version();

// Debugging log functions

extern void ilog_start(char *logname,char *prevlog);
extern void ilog_stop(void);
extern void (*ilog_printf)(char *msg, ...); // dynamic logger (call this mainly)
extern void ilog_quiet(char *msg, ...);  // Quiet logger
extern void ilog_text(char *msg, ...);  // Text logger
extern char ilog_superpanic;				// Set to 1 for trace on exit

// Support routines

extern void ithe_panic(char *m,char *n);     // Crash out with an error
extern void ithe_safepanic(char *m,char *n); // Panic for C++ d'tors
extern void ithe_superpanic();               // Breakpoint
extern void ithe_complain(char *m);          // Complain

#ifndef _WIN32
	#define CRASH(); raise(SIGTRAP);
#else
	#define CRASH(); DebugBreak();
#endif

// IT-HE Virtual Filesystem

typedef struct
	{
	int length;
	int origin;
	char *truename;
	FILE *fp;
	} IFILE;

#define igetb(i) igetc(i)
#define iputb(x,i) iputc(x,i)

#define igetsh_i(i) igetsh_native(i)
#define igetsh_m(i) igetsh_reverse(i)
#define igetl_i(i) igetl_native(i)
#define igetl_m(i) igetl_reverse(i)
#define igetll_i(i) igetll_native(i)
#define igetll_m(i) igetll_reverse(i)
#define iputsh_i(x,i) iputsh_native(x,i)
#define iputsh_m(x,i) iputsh_reverse(x,i)
#define iputl_i(x,i) iputl_native(x,i)
#define iputl_m(x,i) iputl_reverse(x,i)
#define iputll_i(x,i) iputll_native(x,i)
#define iputll_m(x,i) iputll_reverse(x,i)
#define iputlu_i(x,i) iputlu_native(x,i)
#define iputlu_m(x,i) iputlu_reverse(x,i)

extern char *ifile_prefix;
extern unsigned char igetc(IFILE *ifp);
extern unsigned short igetsh_native(IFILE *ifp);
extern unsigned short igetsh_reverse(IFILE *ifp);
extern long igetl_native(IFILE *ifp);
extern long igetl_reverse(IFILE *ifp);
extern unsigned long igetlu_native(IFILE *ifp);
extern unsigned long igetlu_reverse(IFILE *ifp);
extern uqword igetll_native(IFILE *ifp);
extern uqword igetll_reverse(IFILE *ifp);
extern int iread(unsigned char *buf, int l, IFILE *ifp);
extern void iputc(unsigned char c, IFILE *ifp);
extern void iputsh_native(unsigned short s, IFILE *ifp);
extern void iputsh_reverse(unsigned short s, IFILE *ifp);
extern void iputl_native(long l, IFILE *ifp);
extern void iputl_reverse(long l, IFILE *ifp);
extern void iputlu_native(unsigned long l, IFILE *ifp);
extern void iputlu_reverse(unsigned long l, IFILE *ifp);
extern void iputll_native(uqword q, IFILE *ifp);
extern void iputll_reverse(uqword q, IFILE *ifp);
extern int iwrite(unsigned char *buf, int l, IFILE *ifp);
extern unsigned int itell(IFILE *ifp);
extern unsigned int ifilelength(IFILE *ifp);
extern time_t igettime(char *filename);

extern void iseek(IFILE *ifp, int offset, int whence);
extern int iexist(char *filename);
extern IFILE *iopen(char *filename);
extern IFILE *iopen_write(char *filename);

extern void iclose(IFILE *ifp);
extern int ieof(IFILE *ifp);
extern void ihome(char *path);

// Memory subsystem

extern void M_init(void);
extern void M_term(void);
#ifndef FORTIFY
extern void *M_get(unsigned int qty,long amt);
extern void M_free(void *ptr);
extern void *M_get_log(unsigned int qty,long amt,int l,char *f);
extern void M_free_log(void *ptr,int l,char *f);

#ifdef LOG_MEM
#ifndef ILIB_MMOD
#define M_get(a,b) M_get_log(a,b,__LINE__,__FILE__)
#define M_free(a) M_free_log(a,__LINE__,__FILE__)
#endif
#endif

#endif
extern int M_chk(void *ptr);
extern void M_error2(char *msg,unsigned long a);

// String manipulation library

extern char *strrest(char *input);         // Get pointer to tail of string
extern char *strlast(char *input);         // Get pointer to end of tail
extern char *strfirst(char *input);        // Get COPY of head of string
extern char *hardfirst(char *line);        // Mutilate original string
extern char *strgetword(char *line, int p);// Get the word at this position
extern char *itoa(int v, char *s, int r);  // Make a string from an integer
extern void strstrip(char *tbuf);          // Strip a string
extern char isxspace(unsigned char c);     // Is this character whitespace?
extern int strcount(char *a);              // Count number of words
extern int strgetnumber(char *a);          // String-to-number
extern int strisnumber(char *a);           // Is the string a number?
extern void strslash(char *a);             // Convert slashes to what we want
extern void strwinslash(char *a);          // Convert slashes to Windows format

extern char *strLocalBuf(void);        		// Get a local buffer
extern int istricmp(char *a,char *b);		// Fast stricmp
extern int istricmp_fuzzy(char *a,char *b);		// Fuzzy stricmp
extern void strdeck(char *a, char b);		// Kill all instances of one char
extern char *NOTHING;                      // blank, non-NULL string

// DOS functions (For Linux and BeOS, Windows already has them)

#if defined (__linux__) || defined (__BEOS__)

#ifndef ALLEGRO // Allegro emulates these too
	extern void strlwr(char *a);
	extern void strupr(char *a);
	// If no allegro, plug in my istricmp function
	#define stricmp(a,b) istricmp(a,b)
#endif

extern long filelength(int fhandle);

#else
#include <io.h>
#include <string.h>
#endif

#define SAFE_STRCPY(a,b) {strncpy((a),(b),sizeof((a)));a[sizeof((a))-1]=0;}


// Beos is not well

#ifdef __BEOS__
extern int getw(FILE *fp);
extern void putw(int w, FILE *fp);
#endif


// End of library functions

#ifdef __cplusplus
}
#endif

#endif // __ITHE_SUPPORT_LIB__
