/*  Coolwave example.
 *
 *  coolwave.h
 *
 *  Inti Translation of the original GtkGLExt coolwave example.
 *  Copyright (c) 2002 Alif Wahid <awah005@users.sourceforge.net>
 *  Modified by Naofumi Yasufuku  <naofumi@users.sourceforge.net>
 *
 *  Coolwave is a modified version of the old IrisGL demo 'newave',
 *  first ported to OpenGL and Glut by Erik Larsen. It was modified
 *  it to use Gtk and GtkGLExt comprehensively along with ofcourse
 *  OpenGL. Now it has been translated into C++ using Inti.
 */

#include <inti/main.h>
#include <inti/core.h>
#include <inti/gtk/menu.h>
#include <inti/gdk/gl/config.h>
#include <inti/gtk/gl/drawingarea.h>

using namespace Inti;

/*  GLDrawingArea
 */

class GLDrawingArea : public Gtk::GL::DrawingArea
{
	bool animate;
	float beginX;
	float beginY;
	float sphi;
	float stheta;
	float sdepth;
	float aspect;

	Connection timeout_connection;

protected:
	virtual void on_realize();
	virtual bool on_configure_event(const Gdk::EventConfigure& event);
	virtual bool on_expose_event(const Gdk::EventExpose& event);
	virtual bool on_motion_notify_event(const Gdk::EventMotion& event);
	virtual bool on_button_press_event(const Gdk::EventButton& event);
	virtual bool on_key_press_event(const Gdk::EventKey& event);
	virtual bool on_map_event(const Gdk::EventAny& event);
	virtual bool on_unmap_event(const Gdk::EventAny& event);
	virtual bool on_visibility_notify_event(const Gdk::EventVisibility& event);

	bool on_timeout();

public:
	GLDrawingArea(Gdk::GL::Config *glconfig);
	virtual ~GLDrawingArea();

	void on_init_wireframe();
	void on_toggle_animation();

	void timeout_connect();
	void timeout_disconnect();
};

/*  PopupMenu
 */

class PopupMenu : public Gtk::Menu
{
public:
	PopupMenu(GLDrawingArea& drawing_area);
	virtual ~PopupMenu();
};

/*  Window
 */

class Window : public Gtk::Window
{
public:
	Window(Gdk::GL::Config *glconfig);
	virtual ~Window();
};

