//$Id: menu-win.h,v 1.13 2003/06/30 14:07:55 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_MENU_WIN_H
#define GUIKACHU_MENU_WIN_H

#include "menu-res.h"
#include "resource-win.h"

#include <gtk--/window.h>
#include <gtk--/entry.h>
#include <gtk--/clist.h>
#include <gtk--/button.h>
#include <gtk--/label.h>

#include <glade/glade-xml.h>

#include <vector>

namespace Guikachu
{
    namespace GUI
    {
	class MenuWindow: public ResourceWindow,
			  public SigC::Object
	{
	    Resources::Menu *res;

	    GladeXML    *gui;
	    Gtk::Window *window;

	    Gtk::Entry  *id_entry;
	    Gtk::CList  *clist;
	    Gtk::Button *btnUp, *btnDown, *btnRemove;
	    Gtk::Entry  *item_label, *item_id, *item_shortcut;
	    Gtk::Label  *lbl_item_label, *lbl_item_id, *lbl_item_shortcut;
	    Gtk::Button *btnSubmenu, *btnItem, *btnSeparator;
	    
	    struct RowData
	    {
		bool         is_submenu;
		unsigned int index;
		unsigned int parent_index;
	    };
	    
	    std::vector<RowData> clist_rows;
	    std::vector<Resources::Menu::Submenu> submenus;

	public:
	    MenuWindow (Guikachu::Resources::Menu *res);
	    ~MenuWindow ();

	    void show ();
	private:
	    int delete_event_impl (GdkEventAny *e);
	    void update ();
	    bool update_block;
	    void reset_controls ();

	    void id_entry_cb ();
	    void item_id_entry_cb ();
	    void item_label_entry_cb ();
	    void item_shortcut_entry_cb ();
	    
	    void btn_up_cb ();
	    void btn_down_cb ();
	    void btn_remove_cb ();

	    void btn_submenu_cb ();
	    void btn_item_cb (bool separator);
	    
	    void clist_sel_row (gint row, gint column,
				GdkEvent *event);

	    void submenu_up     (unsigned int index);
	    void submenu_down   (unsigned int index);
	    void submenu_remove (unsigned int index);
	    
	    void menuitem_up     (unsigned int parent_index, unsigned int index);
	    void menuitem_down   (unsigned int parent_index, unsigned int index);
	    void menuitem_remove (unsigned int parent_index, unsigned int index);
	};
    }
}

#endif /* !GUIKACHU_MENU_WIN_H */
