//$Id: table-canvas.cc,v 1.20 2004/03/23 22:29:24 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "table-canvas.h"

#include "form-editor.h"
#include "form-editor-canvas.h"
#include "resizeable-ops.h"

#include <gnome--/canvas-polygon.h>
#include <gnome--/canvas-line.h>

using namespace Guikachu::GUI::FormEditor;

namespace
{
void draw_table_line (Gnome::CanvasGroup &group,
                      const std::string  &color,
		      int x1, int y1,
		      int x2, int y2)
{
    using namespace Gnome::CanvasHelpers;

    Gnome::CanvasPoints line_points;
    
    static const char       stipple_bits[] = { 0x02, 0x01, };
    static GdkBitmap *stipple = gdk_bitmap_create_from_data (0,
							     stipple_bits,
							     2, 2);
    
    line_points.push_back (Gnome::Art::Point (x1, y1));
    line_points.push_back (Gnome::Art::Point (x2, y2));

    *(new Gnome::CanvasLine (group, line_points))
	<< fill_color (color)
	<< fill_stipple (stipple)
	<< width_units (1.0);
}
    
} // Anonymous namespace

TableCanvasItem::TableCanvasItem (Widgets::Table     *widget_,
				  Gnome::CanvasGroup *parent_group):
    CanvasItem (widget_, parent_group),
    WidgetCanvasItem (widget_, parent_group),
    ResizeableCanvasItem (widget_, parent_group, new WidgetOps::ResizeOpFactory (widget_)),
    widget (widget_),
    group (0)
{
    update ();
}

void TableCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*draw_group, 0, 0);

    const std::vector<int> &columns = widget->column_width;

    /* Column separators */
    int width  = 0;
    int height = widget->num_rows * 11;
    std::string color = get_foreground_color (true);
    
    int x1 = widget->x;
    int y1 = widget->y;
    int y2 = y1 + std::min (height, widget->get_height ());
    
    draw_table_line (*group, color, x1, y1, x1, y2);

    int num_columns = widget->num_columns;
    for (int i = 0; i < num_columns; i++)
    {
	width += columns[i] + 1;
	int line_x = x1 + width;

	if (width <= widget->get_width ())
	    draw_table_line (*group, color, line_x, y1, line_x, y2);
    }
    
    int x2 = x1 + std::min (width, widget->get_width ());
    
    /* Row separators */
    draw_table_line (*group, color, x1, y1, x2, y1);
    const int row_step = 11;
    int row_y = 0;
    for (int i = 0; i < widget->num_rows; i++)
    {
	row_y += row_step;
	if (row_y > widget->get_height ())
	    break;
	
	draw_table_line (*group, color, x1, y1 + row_y, x2, y1 + row_y);
    }
    
    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    {
	Gnome::CanvasPoints frame_points;
	using Gnome::Art::Point;
	using namespace Gnome::CanvasHelpers;
	
	int cover_x1 = x1;
	int cover_x2 = x1 + widget->get_width ();
	int cover_y1 = y1;
	int cover_y2 = y1 + widget->get_height ();
	
	frame_points.push_back (Point (cover_x1, cover_y1));
	frame_points.push_back (Point (cover_x2, cover_y1));
	frame_points.push_back (Point (cover_x2, cover_y2));
	frame_points.push_back (Point (cover_x1, cover_y2));
	frame_points.push_back (Point (cover_x1, cover_y1));
    
	new Gnome::CanvasPolygon (*group, frame_points);
    }

    set_canvas_item (group);
}
