//$Id: form-editor-canvas.h,v 1.9 2004/01/20 22:52:15 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_CANVAS_H
#define GUIKACHU_FORM_EDITOR_CANVAS_H

#include <gnome--/canvas.h>
#include <gtk/gtkpacker.h> /* For GtkAnchor */
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "form-editor/font.h"
#include "bitmap-res.h"
#include "resource-ref.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace FormEditor
	{
	    Gnome::CanvasItem * draw_text (Gnome::CanvasGroup &group,
                                           const std::string  &text,
                                           const Font         &font,
                                           const Gdk_Color    &color,
                                           int                 x,
                                           int                 y,
                                           int                 clip_width,
                                           int                 clip_height,
                                           GtkAnchorType       anchor = GTK_ANCHOR_CENTER,
                                           bool                multi_line = false);

            GdkPixbuf * render_bitmap (const Magick::Image           &image,
                                       Resources::Bitmap::BitmapType  bitmap_type);

	    // Use this instead of Rectangle canvas items because
	    // those are shoddy
	    Gnome::CanvasItem * draw_rectangle (Gnome::CanvasGroup &group,
                                                int x1, int y1,
                                                int x2, int y2);
	    
	    Gnome::CanvasItem * draw_pixbuf (Gnome::CanvasGroup &group,
                                             GdkPixbuf          *pixbuf,
                                             int                 x = 0,
                                             int                 y = 0);
            
            Gnome::CanvasItem * draw_bitmap (Gnome::CanvasGroup            &group,
                                             const Magick::Image           &image,
                                             Resources::Bitmap::BitmapType  bitmap_type,
                                             const std::string             &background_color,
                                             int                            x,
                                             int                            y,
                                             int                            clip_width = 0,
                                             int                            clip_height = 0,
                                             GtkAnchorType                  anchor = GTK_ANCHOR_NW);

            Gnome::CanvasItem * draw_bitmapref (Gnome::CanvasGroup            &group,
                                                const Properties::ResourceRef &ref_prop,
                                                bool                           color,
                                                const std::string             &background_color,
                                                int                            x,
                                                int                            y,
                                                int                            clip_width = 0,
                                                int                            clip_height = 0,
                                                GtkAnchorType                  anchor = GTK_ANCHOR_NW);
                                                
                                                
	}
    }
}
    
#endif /* !GUIKACHU_FORM_EDITOR_CANVAS_H */
