//$Id: edit-ops.cc,v 1.4 2003/06/30 14:07:55 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include <libgnome/libgnome.h>

#include "edit-ops.h"

#include "io/xml-loader.h"
#include "io/xml-saver.h"

using namespace Guikachu::Edit;

PasteResourceOp::PasteResourceOp (Resource *pasted_resource) :
    manager (pasted_resource->get_manager ()),
    serial (pasted_resource->get_serial ()),
    type (pasted_resource->get_type ()),
    id (pasted_resource->id)
{
    char *op_label_str = g_strdup_printf (_("Paste %s"), id.c_str ());
    op_label = op_label_str;
    g_free (op_label_str);

    IO::XML::ResourceSaver saver (node);
    pasted_resource->apply_visitor (saver);
}

void PasteResourceOp::undo ()
{
    Resource *resource = manager->get_resource (serial);
    g_assert (resource);
    
    manager->remove_resource (resource);
}

void PasteResourceOp::redo ()
{
    Resource *resource = manager->create_resource (type, id, false, serial);

    IO::XML::ResourceLoader loader (node);
    resource->apply_visitor (loader);
}



PasteResourcesOp::PasteResourcesOp (const std::list<Resource*> &pasted_resources)
{
    for (std::list<Resource*>::const_iterator i = pasted_resources.begin ();
	 i != pasted_resources.end (); ++i)
    {
	paste_ops.push_back (new PasteResourceOp (*i));
    }
}

PasteResourcesOp::~PasteResourcesOp ()
{
    for (paste_ops_t::const_iterator i = paste_ops.begin (); i != paste_ops.end (); ++i)
	delete *i;
}
    
std::string PasteResourcesOp::get_label () const
{
    return _("Paste resources");
}

void PasteResourcesOp::undo ()
{
    for (paste_ops_t::const_iterator i = paste_ops.begin (); i != paste_ops.end (); ++i)
	(*i)->undo ();
}

void PasteResourcesOp::redo ()
{
    for (paste_ops_t::const_iterator i = paste_ops.begin (); i != paste_ops.end (); ++i)
	(*i)->undo ();
}



PasteWidgetOp::PasteWidgetOp (Widget *pasted_widget) :
    manager (pasted_widget->get_manager ()),
    form_serial (pasted_widget->get_form ()->get_serial ()),
    widget_serial (pasted_widget->get_serial ()),
    type (pasted_widget->get_type ()),
    id (pasted_widget->id)
{
    char *op_label_str = g_strdup_printf (_("Paste %s into %s"),
					  id.c_str (), pasted_widget->get_form ()->id ().c_str ());
    op_label = op_label_str;
    g_free (op_label_str);

    IO::XML::WidgetSaver saver (node);
    pasted_widget->apply_visitor (saver);
}

void PasteWidgetOp::undo ()
{
    Resources::Form *form = static_cast<Resources::Form*> (manager->get_resource (form_serial));
    Widget *widget = form->get_widget (id);
    g_assert (widget);

    form->remove_widget (widget);
}

void PasteWidgetOp::redo ()
{
    Resources::Form *form = static_cast<Resources::Form*> (manager->get_resource (form_serial));
    Widget *widget = form->create_widget (type, id, false, widget_serial);
    
    IO::XML::WidgetLoader loader (node); 
    widget->apply_visitor (loader);
}



PasteWidgetsOp::PasteWidgetsOp (const std::list<Widget*> &pasted_widgets)
{   
    for (std::list<Widget*>::const_iterator i = pasted_widgets.begin ();
	 i != pasted_widgets.end (); ++i)
    {
	paste_ops.push_back (new PasteWidgetOp (*i));
    }

    std::string form_id = (*pasted_widgets.begin ())->get_form ()->id;
    char *op_label_str = g_strdup_printf (_("Paste widgets into %s"), form_id.c_str ());
    op_label = op_label_str;
    g_free (op_label_str);
}

PasteWidgetsOp::~PasteWidgetsOp ()
{
    for (paste_ops_t::const_iterator i = paste_ops.begin (); i != paste_ops.end (); ++i)
	delete *i;
}

void PasteWidgetsOp::undo ()
{
    for (paste_ops_t::const_iterator i = paste_ops.begin (); i != paste_ops.end (); ++i)
	(*i)->undo ();
}

void PasteWidgetsOp::redo ()
{
    for (paste_ops_t::const_iterator i = paste_ops.begin (); i != paste_ops.end (); ++i)
	(*i)->undo ();
}
