/*
 * Copyright (C) 1997, 1998 Free Software Foundation
 * Copyright (C) 1995, 1996 Eric M. Ludlam
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.org.
 * 
 * gtl_cw.c
 *
 * Purpose:
 *   Simple bits of code used to make copyright information available
 * at runtime for all the utilities which use ETALK library source
 * code.  These functions will be accessed on the command line for
 * most applications.
 *
 * $Log: gtl_cw.c,v $
 * Revision 1.8  1998/01/04 15:16:04  zappo
 * Update copyright year.
 *
 * Revision 1.7  1997/12/14 19:21:02  zappo
 * Renamed package to gtalk, renamed symbols and files apropriately
 * Fixed copyright and email address.
 *
 * Revision 1.6  1997/11/01 13:27:37  zappo
 * changed my email
 *
 * Revision 1.5  1997/10/25 01:50:04  zappo
 * Fixed the copyright information.
 *
 * Revision 1.4  1996/03/03 15:44:10  zappo
 * Updated copyright dates
 *
 * Revision 1.3  1995/12/10  03:40:36  zappo
 * Modified to use DISP_message
 *
 * Revision 1.2  1995/06/13  00:04:28  zappo
 * Some compilers can't handle multi-line strings. Changed to many calls
 * to printf.
 *
 * Revision 1.1  1995/05/09  23:46:46  zappo
 * Initial revision
 *
 * ::Header:: gtalklib.h
 */
#include "gtalklib.h"

static char *copyleft[] =
{
  " Copyright (C) 1994, 95, 96, 97, 98 Free Software Foundation",
  "",
  " This program is free software; you can redistribute it and/or modify",
  " it under the terms of the GNU General Public License as published by",
  " the Free Software Foundation; either version 2, or (at your option)",
  " any later version.",
  "",
  " This program is distributed in the hope that it will be useful,",
  " but WITHOUT ANY WARRANTY; without even the implied warranty of",
  " MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the",
  " GNU General Public License for more details.",
  "",
  " You should have received a copy of the GNU General Public License",
  " along with this program; if not, you can either send email to this",
  " program's author (see below) or write to:",
  "",
  "              The Free Software Foundation, Inc.",
  "              675 Mass Ave.",
  "              Cambridge, MA 02139, USA. ",
  "",
  " Please send bug reports, etc. to zappo@gnu.org."
};


/*
 * Function: CW_display_copywrite
 *
 *   Prints out the copywrite notice warning that this is free
 * software and all that other cool stuff.
 *
 * Returns:     Nothing
 * Parameters:  None
 *
 * History:
 * zappo   5/9/95     Created
 */
void CW_display_copywrite()
{
  int i;
  for(i = 0; i < (sizeof(copyleft)/sizeof(char *)); i++)
    DISP_message(NULL, copyleft[i], LOG_DEBUG);
}
