# $Id: en.pm,v 1.2 2003/02/01 17:26:10 jodrell Exp $
package Greenwich::L10N::en;

@ISA = qw(Greenwich::L10N);

### The maintainer for this language module is Gavin Brown <gavin.brown@uk.com>.

%Lexicon = (
	# legal-ish copyright string:
	'copyright'	=> 'This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.',
	# brief description of the program
	'comments'	=> 'A whois client for GNOME written in Perl',
	# what gets printed when you run --help on the command line
	'usage'		=> "%s, version %s - %s
USAGE: %s OPTIONS

        --help          Print this message
        --geometry      Create the main window with the specified geometry, e.g.

                        %s --geometry=500x600

%s
",
	'serverlist'		=> 'Server List',				# this appears in the 'Settings' menu
	'languages'		=> 'Languages',					# this appears in the 'Help' menu
	'savehint'		=> 'Save the current buffer',			# this is the tooltip for the 'Save' button
	'prefshint'		=> 'Preferences',				# this is the tooltip for the 'Preferences' button
	'queryhint'		=> 'Send the query to the server',		# this is the tooltip for the 'Query' button
	'helphint'		=> 'Get Help',					# this is the tooltip for the 'Help' button
	'quithint'		=> 'Quit the program',				# this is the tooltip for the 'Quit' button
	'stophint'		=> 'Halt the Query',				# this is the tooltip for the 'Stop' button
	'server'		=> 'Server:',					# this is the label for the Server name input
	'port'			=> 'Port:',					# this is the label for the Server port input
	'query'			=> 'Query:',					# this is the label for the query input
	'ready'			=> 'Ready.',					# this is the default status bar contents.
	'nohost'		=> 'Please enter a hostname first!',		# this is an error message
	'running'		=> 'Running %s...',				# this is a status bar message for running an external program
	'done'			=> 'Done in %d seconds.',			# this is a status bar message
	'connecting'		=> 'Connecting to %s...',			# this is a status bar message
	'selectfile'		=> 'Select file to save to:',			# this is the title text of the 'Save File' dialogue
	'confirmoverwrite'	=> 'Confirm overwrite',				# this is the title text of the 'confirm overwrite' dialogue
	'bufferwritten'		=> 'Buffer written to %s.',			# this is a status bar message
	'prefstitle'		=> 'Preferences',				# this is appended to the program name in the Prefs dialogue
	'whoisprefs'		=> 'Whois settings:',				# this is the title of the whois prefs tab
	'useexternal'		=> 'Use an external program to query whois server:', # this is the label for the external program input
	'fontprefs'		=> 'Font settings:',				# this is the title of the font prefs tab
	'selectfont'		=> 'Please Select a Font:',			# this is the label for the font input
	'netprefs'		=> 'Network Settings:',				# this is the title of the network prefs tab
	'timeout'		=> 'Timeout for network connections:',		# this is the label of the timeout input
	'recursiveprefs'	=> 'Recursive Options',				# this is the title of the recusrive prefs tab
	'dorecursive'		=> 'Perform recursive lookups (see help for details)', # this is the label of the recursive checkbox
	'whoislabel'		=> 'Whois',					# label for the Whois prefs tab
	'displaylabel'		=> 'Display',					# label for the Display prefs tab
	'netlabel'		=> 'Network',					# label for the Network prefs tab
	'recursivelabel'	=> 'Recursive',					# label for the Recursive prefs tab
	'yourservers'		=> 'Your Servers',				# title for the Server List
	'addserver'		=> 'Add Server',				# label for the Add Server button
	'entername'		=> 'Enter a server name:',			# prompt for entering a server name
	'deleteserver'		=> 'Delete Server',				# label for the Delete Server button
	'using'			=> 'Using %s:',					# title for the Help window
	'error'			=> 'Error',					# generic 'Error' word
	# error message to put in the status bar when defaulting to english (needed in en.pm ONLY):
	'languageerror'		=> "Couldn't load language module for '$ENV{LANG}', defaulting to English",
	'autodetect'		=> 'Auto-detect',				# used for the auto-detect checkbutton
	'extstring'		=> '%s = server; %q = query',			# used to demonstrate the syntax for the external whois
);

1;
