/* $Id: hedges.h,v 1.7 2005/04/05 12:02:56 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#ifndef HEDGES_H
#define HEDGES_H

#include "voronoi/site.h"
#include "voronoi/edges.h"

namespace Voronoi {

struct Halfedge {
    Halfedge    *ELleft, *ELright;
    Edge               *ELedge;
    int                ELrefcnt;
    EdgeEnd            ELpm;
    Site               *vertex;
    double              ystar;
    Halfedge    *PQnext;
};

struct Halfedges {
	Halfedge *leftend, *rightend;
	Freelist<Halfedge> fhedges;
	std::vector<Halfedge*> hash;
	Rect range; // of site coords
	Site *bottomsite; // weird to hold this here but this is the only class that uses it
	Sites &sites;

	Halfedges(Sites &sites,int N);
	void init(int N);
	Site *hintersect(Halfedge*, Halfedge*);
	Halfedge *create(Edge*, EdgeEnd);
	void insert(Halfedge *where, Halfedge *he);
	Halfedge *leftbnd(Coord);
	void erase(Halfedge *);
	Halfedge *ELleftbnd(Coord);
	Site *leftreg(Halfedge*), *rightreg(Halfedge*);

	void PQinitialize();
	Halfedge * PQextractmin();
	Coord PQ_min();
	int PQempty();
	void PQdelete(Halfedge*);
	void PQinsert(Halfedge*, Site*, double);

private:
	Halfedge *gethash(int b);

	std::vector<Halfedge> PQhash;
	int PQhashsize;
	int PQcount;
	int PQmin;

	int PQbucket(Halfedge *he);
};
bool right_of(Halfedge*, Coord);
inline Halfedge *left(Halfedge*he) {
	return he->ELleft;
}
inline Halfedge *right(Halfedge*he) {
	return he->ELright;
}

} // namespace Voronoi
#endif
