//====================================================
// Grande
// Copyright (C) 2002-2003, kacchan
// E-M@il address   ml@kxl.hn.org
// Homepage address http://kxl.hn.org
//====================================================
#include "grande.h"
#include "extern.h"

//========================================
// ᡼(ե졼ढ)
//========================================
void DrawImageFrame(CharacterData *my)
{
  KXL_PutImage(my->Spr->data[my->FrameNo].img, my->X, my->Y);
}
//========================================
// ᡼õ
//========================================
void ClearImage(CharacterData *my)
{
  // 褷ʤ
}
//========================================
// äդ
//========================================
RcHitEnum HitDelete(CharacterData *my, CharacterData *your)
{
  return RcHitDel;
}
//========================================
// äƤؤä
//========================================
RcHitEnum HitNone(CharacterData *my, CharacterData *your)
{
  return RcHitNone;
}
//========================================
// ܰư(˥ʤ)
//========================================
RcHitEnum MoveStandardNoFrame(CharacterData *my)
{
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->Y < UP_TOP - my->Spr->data[my->FrameNo].img->Height ||
      my->Y > UP_BOTTOM ||
      my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  return RcHitNone;
}
//========================================
// ܰư(˥ᤢ)
//========================================
RcHitEnum MoveStandardFrame(CharacterData *my)
{
  if (++ my->FrameNo == my->FrameMax)
    my->FrameNo = 0;
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->Y < UP_TOP - my->Spr->data[my->FrameNo].img->Height ||
      my->Y > UP_BOTTOM ||
      my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  return RcHitNone;
}
//========================================
// Ѽ
//========================================
Uint16 GetDirection(CharacterData *my, CharacterData *your)
{
  KXL_Rect src, dest;
  KXL_Image *mi = my->Spr->data[my->FrameNo].img;
  KXL_Image *yi = your->Spr->data[your->FrameNo].img;

  src.Left    = my->X;
  src.Top     = my->Y;
  src.Width   = mi->Width;
  src.Height  = mi->Height;
  dest.Left   = your->X;
  dest.Top    = your->Y;
  dest.Width  = yi->Width;
  dest.Height = yi->Height;
  return KXL_GetDirection(src, dest);
}
//========================================
// ٤ˤûͼ
//========================================
void GetDirectionAdd(Uint16 direction, Sint16 *ax, Sint16 *ay, Uint16 speed)
{
  KXL_GetDirectionAdd(direction, ax, ay);
  *ax *= speed;
  *ay *= speed;
}
//========================================
// ơꥢ&४С
//========================================
void ClearAndGameOver(void)
{
  static Uint16 no;
  Uint16 y[] = {10, 20, 30, 40, 50, 60, 70, 80, 90, 80, 70, 60, 50, 40, 30, 20, 10, 0};
  Uint16 i;
  Uint8 *str[3] = {"Clear", "GameOver", "See you next"};

  if (Root->Cnt == 0) {
    ScoreRanking();
    if (Root->MainFlag == MainClear)
      no = (Root->Stage == 3) ? 2 : 0;
    else
      no = 1;
  }
  KXL_Font("-bitstream-charter-bold-*-normal-*-60-*-*-*-*-*-*-*", 0x00, 0x00, 0x00);
  for (i = 0; i < 2; i ++) {
    KXL_Font(NULL, i * 0xff, i * 0xff, i * 0xff);
    KXL_PutText(UP_LEFT + 2 + (WIDTH - KXL_TextWidth(str[no])) / 2,
                UP_TOP + 100 + 2 - i + y[Root->Cnt % 18],
                str[no]);
  }
  KXL_Font( "-adobe-courier-bold-r-normal--14-*-*-*-*-*-iso8859-1", 0xff, 0xff, 0xff);
  if (Root->Cnt >= 50) {
    KXL_DrawRectangle(UP_LEFT, UP_TOP,
                      WIDTH, (Root->Cnt - 50) * 8, True);
    KXL_DrawRectangle(UP_LEFT, UP_BOTTOM - (Root->Cnt - 50) * 8 + 1,
                      WIDTH, (Root->Cnt - 50) * 8, True);
  }
  if (Root->Cnt == 80) {
    UnLoadStageData();
    if (Root->MainFlag == MainClear) {
      Root->MainFlag = MainStart;
      if (++ Root->Stage == 4) {
        //KXL_PlaySound(SE_BGM, KXL_SOUND_STOP_ALL);
        Root->MainFlag = MainOpening;
      }
    } else {
      //KXL_PlaySound(SE_BGM, KXL_SOUND_STOP_ALL);
      Root->MainFlag = MainOpening;
    }
  }
}
//========================================
// ॹ
//========================================
void Start(void)
{
  //KXL_PlaySound(SE_BGM, KXL_SOUND_STOP_ALL);
  CreateShip();
  LoadStageData();
  Root->MainFlag = MainGame;
  //KXL_PlaySound(SE_BGM, KXL_SOUND_PLAY_LOOP);
}
