#include "gradm.h"

int
is_valid_elf_binary(const char *filename)
{
	struct elf32_hdr header_elf;
	int fd;

	if ((fd = open(filename, O_RDONLY)) < 0)
		return 0;

	if ((read(fd, &header_elf, sizeof (header_elf)) != sizeof (header_elf)))
		goto failure;

	if (strncmp(header_elf.e_ident, ELFMAG, SELFMAG))
		goto failure;

	if (header_elf.e_type != ET_EXEC && header_elf.e_type != ET_DYN)
		goto failure;

	close(fd);
	return 1;
      failure:
	close(fd);
	return 0;
}

static void
find_gradm_path(char *gradm_realpath)
{
	char gradm_procpath[21] = { 0 };

	snprintf(gradm_procpath, sizeof (gradm_procpath),
		 "/proc/%d/exe", getpid());

	if (readlink(gradm_procpath, gradm_realpath, PATH_MAX - 1) < 0)
		failure("readlink");

	return;
}

void
add_gradm_acl(void)
{
	struct stat fstat;
	char gradm_realpath[PATH_MAX] = { 0 };
	char *gradm_name;
	struct ip_acl ip;

	find_gradm_path(gradm_realpath);

	def_acl_tmp->cap_raise_tmp = 0;
	def_acl_tmp->cap_drop_tmp = 0;

	if (!stat("/proc/sys/kernel/grsecurity/acl", &fstat)) {
		if (!add_proc_object_acl(&(def_acl_tmp->filp),
					 "/proc/sys/kernel/grsecurity/acl",
					 proc_object_mode_conv("w"), GR_FEXIST))
			exit(EXIT_FAILURE);
	} else {
		fprintf(stderr, "/proc/sys/kernel/grsecurity/acl does not "
			"exist.  Please recompile your kernel with "
			"grsecurity's ACL system.\n");
		exit(EXIT_FAILURE);
	}
	if (!add_proc_object_acl(&(def_acl_tmp->filp), "/",
				 proc_object_mode_conv("h"), GR_FEXIST))
		exit(EXIT_FAILURE);

	memset(&ip, 0, sizeof (ip));
	add_ip_acl(&(def_acl_tmp->ipp), GR_IP_CONNECT, &ip);
	add_ip_acl(&(def_acl_tmp->ipp), GR_IP_BIND, &ip);

	gradm_name = strdup(gradm_realpath);

	if (!add_proc_object_acl(&(def_acl_tmp->filp), gradm_name,
				 proc_object_mode_conv("x"), GR_FEXIST))
		exit(EXIT_FAILURE);
	add_cap_acl(&def_acl_tmp, "-CAP_ALL");
	add_cap_acl(&def_acl_tmp, "+CAP_IPC_LOCK");
	if (!add_proc_subject_acl(&def_acl_tmp, gradm_name,
				  proc_subject_mode_conv("do")))
		exit(EXIT_FAILURE);
	return;
}

void
add_admin_acl(void)
{
	def_acl_tmp->cap_raise_tmp = 0;
	def_acl_tmp->cap_drop_tmp = 0;

	if (!add_proc_object_acl
	    (&(def_acl_tmp->filp), "/", proc_object_mode_conv("rwxi"),
	     GR_FEXIST))
		exit(EXIT_FAILURE);
	add_cap_acl(&def_acl_tmp, "+CAP_ALL");
	if (!add_proc_subject_acl
	    (&def_acl_tmp, "god", proc_subject_mode_conv("kvo")))
		exit(EXIT_FAILURE);

	return;
}

void
add_kernel_acl(void)
{
	def_acl_tmp->cap_raise_tmp = 0;
	def_acl_tmp->cap_drop_tmp = 0;

	if (!add_proc_object_acl
	    (&(def_acl_tmp->filp), "/", proc_object_mode_conv("rx"), GR_FEXIST))
		exit(EXIT_FAILURE);
	if (!add_proc_object_acl
	    (&(def_acl_tmp->filp), "/etc/grsec", proc_object_mode_conv("h"),
	     GR_FEXIST))
		exit(EXIT_FAILURE);
	if (!add_proc_subject_acl
	    (&def_acl_tmp, "kernel", proc_subject_mode_conv("o")))
		exit(EXIT_FAILURE);

	return;
}
