/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 Peter Stamfest

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: browse.h,v 1.38 2003/11/03 21:07:56 stamfest Exp $ */

#ifndef GQ_BROWSE_H_INCLUDED
#define GQ_BROWSE_H_INCLUDED

#include "common.h"
#include "mainwin.h"   /* struct tab */

#define BROWSETAB(tab) (assert(tab->type == BROWSE_MODE), ((struct tab_browse *)tab->modeinfo))
struct tab_browse {
     GList *cur_path;

     GtkCTree *ctreeroot;
     GtkWidget *ctree_refresh;        /* XXX try to get rid of this */
     GtkWidget *pane2_scrwin;
     GtkWidget *pane2_vbox;
     GtkWidget *mainpane;
     GtkCTreeNode *tree_row_selected;
     struct inputform *inputform;

     /* stuff that only gets used temporary, i.e. hacks */
     GtkCTreeNode *tree_row_popped_up;
     GtkCTreeNode *selected_ctree_node;

     /* lock used to suppress flickering during d'n'd */
     int update_lock;

     /* used to store old hide-button state - Hack */
     int hidden;
};

struct browse_entry_vtab;

/* the basic browse entry layout */
typedef struct {
     /* common */
     int type;
     struct browse_entry_vtab *base_methods;
} browse_entry;

/** Define an OO style object hierarchy for the payload data for CTree
    Nodes of the browsing tree. */

/* Callback types to avoid a lot of warnings when assigning to the
   virtual function table */
typedef void (*browse_entry_destructor)(browse_entry *entry);

typedef void (*browse_entry_expand)(browse_entry *entry,
				    int error_context,
				    GtkCTree *ctreeroot,
				    GtkCTreeNode *node,
				    struct tab *tab);
typedef void (*browse_entry_select)(browse_entry *entry,
				    int error_context,
				    GtkCTree *ctreeroot,
				    GtkCTreeNode *node,
				    struct tab *tab);
typedef void (*browse_entry_refresh)(browse_entry *entry,
				     int error_context,
				     GtkCTree *ctreeroot,
				     GtkCTreeNode *node,
				     struct tab *tab);
typedef char* (*browse_entry_get_name)(browse_entry *entry,
				       gboolean long_form);
typedef void (*browse_entry_popup)(browse_entry *entry,
				   GtkWidget *menu, 
				   GtkWidget *ctreeroot,
				   GtkCTreeNode *ctree_node,
				   struct tab *tab);

void destroy_browse_entry(browse_entry *entry);

#define IS_ENTRY(o,t) ((o) && (((browse_entry *)(o))->type == t))

/* The basic methods */
struct browse_entry_vtab {
     /* destructor */
     browse_entry_destructor		destroy;

     /* expansion callback of corresponding GtkCtreeNode */
     browse_entry_expand		expand;

     /* select callback of corresponding GtkCtreeNode */
     browse_entry_select		select;

     /* refresh callback of corresponding GtkCtreeNode */
     browse_entry_refresh		refresh;

     /* Gets the user visible name of the node, must be freed using g_free */
     browse_entry_get_name		get_name;

     /* implements the popup menu for the entry */
     browse_entry_popup			popup;
};



void record_path(struct tab *tab, browse_entry *entry,
		 GtkCTree *ctreeroot, GtkCTreeNode *node);



/**************************************************************************/

/* get the server object for the current entry */
struct ldapserver *server_from_node(GtkCTree *ctreeroot,
				    GtkCTreeNode *node);

/* void cleanup_browse_mode(struct tab *tab); */
struct tab *new_browsemode();

void refresh_subtree(int error_context,
		     GtkCTree *ctree,
		     GtkCTreeNode *node);

void refresh_subtree_new_dn(int error_context,
			    GtkCTree *ctree,
			    GtkCTreeNode *node,
			    const char *newdn,
			    int options);

void refresh_subtree_with_options(int error_context,
				  GtkCTree *ctree,
				  GtkCTreeNode *node,
				  int options);

GtkCTreeNode *show_server_dn(int error_context,
			     GtkCTree *tree,
			     struct ldapserver *server, const char *dn,
			     gboolean select_node);
GtkCTreeNode *show_dn(int error_context,
		      GtkCTree *tree, GtkCTreeNode *node, const char *dn,
		      gboolean select_node);

GtkCTreeNode *node_from_dn(GtkCTree *ctreeroot,
			   GtkCTreeNode *top,
			   char *dn);

/* void add_single_server(struct tab *tab, struct ldapserver *server); */

GtkCTreeNode *dn_browse_single_add(const char *dn,
				   GtkCTree *ctree,
				   GtkCTreeNode *node);


/* options to the refresh_subtree_with_options functions */
/* NOTE: browse-dnd.h defines additional options starting at 256 */
#define REFRESH_FORCE_EXPAND	1
#define REFRESH_FORCE_UNEXPAND	2

GtkCTreeNode *tree_node_from_server_dn(GtkCTree *ctree,
				       struct ldapserver *server,
				       const char *dn);

void update_browse_serverlist(struct tab *tab);
void tree_row_close_connection(GtkMenuItem *menuitem, struct tab *tab);

void set_update_lock(struct tab *tab);
void release_update_lock(struct tab *tab);


#endif


/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */

