#!/usr/bin/perl
#
# Parse squid log and write current traffic usage by users
#
# Igor Muratov <migor@altlinux.org>
#

use strict;
use DB_File;
use Date::Format;

my $log = '/var/log/squid/access.log';
my $db = '/var/spool/squid/quota.db';
my %quota;
my $format = "L L L";

tie(%quota, 'DB_File', $db, O_CREAT|O_RDWR);

printf "LAST TIME: %s\nLAST STRING: %d\n\n",
	time2str("%d.%m.%Y %H:%M:%S",$quota{TIMESTAMP}),
	$quota{STRING_NUMBER};
print "USER\tTIME\tBYTES\n";

foreach my $user (keys %quota)
{
	next if $user eq "TIMESTAMP";
	next if $user eq "STRING_NUMBER";

	my ($bytes, $first, $last) = unpack($format, $quota{$user});
	my $first_time = time2str("%d.%m.%Y %H:%M:%S",$first);
	my $last_time = time2str("%d.%m.%Y %H:%M:%S",$last);
	my $traffic = $bytes / 1024 / 1000;
	printf "%s\t%s\t%s\t%5.2f\n", $user, $first_time, $last_time, $traffic;
}
untie %quota;
