#!/usr/bin/perl
#
# Parse squid log and write current traffic usage by users
#
# Igor Muratov <migor@altlinux.org>
#

use strict;
use DB_File;
use Fcntl;

my $log = '/var/log/squid/access.log';
my $db = '/var/spool/squid/quota.db';
my %quota;
my @lines;
my $format = "L L L";

tie(%quota, 'DB_File', $db, O_CREAT|O_RDWR);
my $tie = tie(@lines, 'DB_File', $log, O_RDWR, 0660, $DB_RECNO)
	or die "Cannot open file $log: $!\n";

my ($time, $user, $bytes);
my $count = 0;

my $index = $quota{STRING_NUMBER} > $tie->length ? 0 : $quota{STRING_NUMBER};
while($lines[$index])
{
	my @line = split / +/, $lines[$index];
	$index++;
	$count++;

	# Skip line for local traffic
	(my $errcode = $line[3]) =~ s/(\w+)\/(\d+)/$1/;
	next if $errcode eq "NONE";
	next if $errcode eq "TCP_HIT";
	next if $errcode eq "TCP_DENIED";

	# Get username, access time and data size
	($user = $line[7]) =~ s/^-$/anonymous/;
	$time = $line[0];
	$bytes = $line[4];

	# Update timestamps and traffic counter for user
	my ($traffic, $first, $last) = unpack($format, $quota{$user});
	$quota{$user} = pack(
		$format,
		$traffic + $bytes,
		$first || $time,
		$time
	);
}
#warn "Processed $count new lines\n";

# Memorize timestamp and line number
$quota{TIMESTAMP} = $time;
$quota{STRING_NUMBER} = $index;

untie @lines;
untie %quota;
