/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 * Licensed under the GNU GPL.
 * Absolutely no warranty.
 */

#ifndef RWLOCK_H
#define RWLOCK_H

#include <pthread.h>

#define MAX_THREADS 2

struct readers {
    int is_valid;
    pthread_t tid;
    int rcount;
};

typedef struct {
    pthread_mutex_t lock;
    pthread_cond_t cond;
    pthread_t writer_tid;
    int wcount;
    struct readers readers[MAX_THREADS];
} rwlock;

void
rwlock_wlock(rwlock *rwl);

void
rwlock_rlock(rwlock *rwl);

void
rwlock_wunlock(rwlock *rwl);

void
rwlock_runlock(rwlock *rwl);

void
rwlock_init(rwlock *rwl);

void
rwlock_destroy(rwlock *rwl);

#endif /* ! RWLOCK_H */
