
#include "config.h"
#include "mixer.h"

void
mixer_unity_mux_1to1_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
    }
}

void
mixer_unity_mux_2to2_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
    }
}

void
mixer_unity_mux_3to3_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
    }
}

void
mixer_unity_mux_4to4_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
    }
}

void
mixer_unity_mux_5to5_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
    }
}

void
mixer_unity_mux_6to6_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
    }
}

void
mixer_unity_mux_7to7_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
    }
}

void
mixer_unity_mux_8to8_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
    }
}

void
mixer_unity_mux_9to9_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
    }
}

void
mixer_unity_mux_10to10_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
    }
}

void
mixer_unity_mux_11to11_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
    }
}

void
mixer_unity_mux_12to12_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
    }
}

void
mixer_unity_mux_13to13_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
    }
}

void
mixer_unity_mux_14to14_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
    }
}

void
mixer_unity_mux_15to15_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
    }
}

void
mixer_unity_mux_16to16_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
    }
}

void
mixer_unity_mux_17to17_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
    }
}

void
mixer_unity_mux_18to18_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
    }
}

void
mixer_unity_mux_19to19_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
    }
}

void
mixer_unity_mux_20to20_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
    }
}

void
mixer_unity_mux_21to21_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
    }
}

void
mixer_unity_mux_22to22_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
    }
}

void
mixer_unity_mux_23to23_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
    }
}

void
mixer_unity_mux_24to24_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
    }
}

void
mixer_unity_mux_25to25_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
        fb8t[mul + 24] = fb8s[24][i];
    }
}

void
mixer_unity_mux_26to26_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
        fb8t[mul + 24] = fb8s[24][i];
        fb8t[mul + 25] = fb8s[25][i];
    }
}

void
mixer_unity_mux_27to27_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
        fb8t[mul + 24] = fb8s[24][i];
        fb8t[mul + 25] = fb8s[25][i];
        fb8t[mul + 26] = fb8s[26][i];
    }
}

void
mixer_unity_mux_28to28_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
        fb8t[mul + 24] = fb8s[24][i];
        fb8t[mul + 25] = fb8s[25][i];
        fb8t[mul + 26] = fb8s[26][i];
        fb8t[mul + 27] = fb8s[27][i];
    }
}

void
mixer_unity_mux_29to29_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
        fb8t[mul + 24] = fb8s[24][i];
        fb8t[mul + 25] = fb8s[25][i];
        fb8t[mul + 26] = fb8s[26][i];
        fb8t[mul + 27] = fb8s[27][i];
        fb8t[mul + 28] = fb8s[28][i];
    }
}

void
mixer_unity_mux_30to30_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
        fb8t[mul + 24] = fb8s[24][i];
        fb8t[mul + 25] = fb8s[25][i];
        fb8t[mul + 26] = fb8s[26][i];
        fb8t[mul + 27] = fb8s[27][i];
        fb8t[mul + 28] = fb8s[28][i];
        fb8t[mul + 29] = fb8s[29][i];
    }
}

void
mixer_unity_mux_31to31_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
        fb8t[mul + 24] = fb8s[24][i];
        fb8t[mul + 25] = fb8s[25][i];
        fb8t[mul + 26] = fb8s[26][i];
        fb8t[mul + 27] = fb8s[27][i];
        fb8t[mul + 28] = fb8s[28][i];
        fb8t[mul + 29] = fb8s[29][i];
        fb8t[mul + 30] = fb8s[30][i];
    }
}

void
mixer_unity_mux_32to32_8(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int8_t *fb8t = (int8_t *)fb_target, **fb8s = (int8_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb8t[mul + 0] = fb8s[0][i];
        fb8t[mul + 1] = fb8s[1][i];
        fb8t[mul + 2] = fb8s[2][i];
        fb8t[mul + 3] = fb8s[3][i];
        fb8t[mul + 4] = fb8s[4][i];
        fb8t[mul + 5] = fb8s[5][i];
        fb8t[mul + 6] = fb8s[6][i];
        fb8t[mul + 7] = fb8s[7][i];
        fb8t[mul + 8] = fb8s[8][i];
        fb8t[mul + 9] = fb8s[9][i];
        fb8t[mul + 10] = fb8s[10][i];
        fb8t[mul + 11] = fb8s[11][i];
        fb8t[mul + 12] = fb8s[12][i];
        fb8t[mul + 13] = fb8s[13][i];
        fb8t[mul + 14] = fb8s[14][i];
        fb8t[mul + 15] = fb8s[15][i];
        fb8t[mul + 16] = fb8s[16][i];
        fb8t[mul + 17] = fb8s[17][i];
        fb8t[mul + 18] = fb8s[18][i];
        fb8t[mul + 19] = fb8s[19][i];
        fb8t[mul + 20] = fb8s[20][i];
        fb8t[mul + 21] = fb8s[21][i];
        fb8t[mul + 22] = fb8s[22][i];
        fb8t[mul + 23] = fb8s[23][i];
        fb8t[mul + 24] = fb8s[24][i];
        fb8t[mul + 25] = fb8s[25][i];
        fb8t[mul + 26] = fb8s[26][i];
        fb8t[mul + 27] = fb8s[27][i];
        fb8t[mul + 28] = fb8s[28][i];
        fb8t[mul + 29] = fb8s[29][i];
        fb8t[mul + 30] = fb8s[30][i];
        fb8t[mul + 31] = fb8s[31][i];
    }
}

void
mixer_unity_mux_1to1_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
    }
}

void
mixer_unity_mux_2to2_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
    }
}

void
mixer_unity_mux_3to3_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
    }
}

void
mixer_unity_mux_4to4_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
    }
}

void
mixer_unity_mux_5to5_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
    }
}

void
mixer_unity_mux_6to6_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
    }
}

void
mixer_unity_mux_7to7_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
    }
}

void
mixer_unity_mux_8to8_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
    }
}

void
mixer_unity_mux_9to9_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
    }
}

void
mixer_unity_mux_10to10_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
    }
}

void
mixer_unity_mux_11to11_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
    }
}

void
mixer_unity_mux_12to12_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
    }
}

void
mixer_unity_mux_13to13_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
    }
}

void
mixer_unity_mux_14to14_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
    }
}

void
mixer_unity_mux_15to15_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
    }
}

void
mixer_unity_mux_16to16_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
    }
}

void
mixer_unity_mux_17to17_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
    }
}

void
mixer_unity_mux_18to18_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
    }
}

void
mixer_unity_mux_19to19_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
    }
}

void
mixer_unity_mux_20to20_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
    }
}

void
mixer_unity_mux_21to21_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
    }
}

void
mixer_unity_mux_22to22_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
    }
}

void
mixer_unity_mux_23to23_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
    }
}

void
mixer_unity_mux_24to24_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
    }
}

void
mixer_unity_mux_25to25_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
        fb16t[mul + 24] = fb16s[24][i];
    }
}

void
mixer_unity_mux_26to26_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
        fb16t[mul + 24] = fb16s[24][i];
        fb16t[mul + 25] = fb16s[25][i];
    }
}

void
mixer_unity_mux_27to27_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
        fb16t[mul + 24] = fb16s[24][i];
        fb16t[mul + 25] = fb16s[25][i];
        fb16t[mul + 26] = fb16s[26][i];
    }
}

void
mixer_unity_mux_28to28_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
        fb16t[mul + 24] = fb16s[24][i];
        fb16t[mul + 25] = fb16s[25][i];
        fb16t[mul + 26] = fb16s[26][i];
        fb16t[mul + 27] = fb16s[27][i];
    }
}

void
mixer_unity_mux_29to29_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
        fb16t[mul + 24] = fb16s[24][i];
        fb16t[mul + 25] = fb16s[25][i];
        fb16t[mul + 26] = fb16s[26][i];
        fb16t[mul + 27] = fb16s[27][i];
        fb16t[mul + 28] = fb16s[28][i];
    }
}

void
mixer_unity_mux_30to30_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
        fb16t[mul + 24] = fb16s[24][i];
        fb16t[mul + 25] = fb16s[25][i];
        fb16t[mul + 26] = fb16s[26][i];
        fb16t[mul + 27] = fb16s[27][i];
        fb16t[mul + 28] = fb16s[28][i];
        fb16t[mul + 29] = fb16s[29][i];
    }
}

void
mixer_unity_mux_31to31_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
        fb16t[mul + 24] = fb16s[24][i];
        fb16t[mul + 25] = fb16s[25][i];
        fb16t[mul + 26] = fb16s[26][i];
        fb16t[mul + 27] = fb16s[27][i];
        fb16t[mul + 28] = fb16s[28][i];
        fb16t[mul + 29] = fb16s[29][i];
        fb16t[mul + 30] = fb16s[30][i];
    }
}

void
mixer_unity_mux_32to32_16(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int16_t *fb16t = (int16_t *)fb_target, **fb16s = (int16_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb16t[mul + 0] = fb16s[0][i];
        fb16t[mul + 1] = fb16s[1][i];
        fb16t[mul + 2] = fb16s[2][i];
        fb16t[mul + 3] = fb16s[3][i];
        fb16t[mul + 4] = fb16s[4][i];
        fb16t[mul + 5] = fb16s[5][i];
        fb16t[mul + 6] = fb16s[6][i];
        fb16t[mul + 7] = fb16s[7][i];
        fb16t[mul + 8] = fb16s[8][i];
        fb16t[mul + 9] = fb16s[9][i];
        fb16t[mul + 10] = fb16s[10][i];
        fb16t[mul + 11] = fb16s[11][i];
        fb16t[mul + 12] = fb16s[12][i];
        fb16t[mul + 13] = fb16s[13][i];
        fb16t[mul + 14] = fb16s[14][i];
        fb16t[mul + 15] = fb16s[15][i];
        fb16t[mul + 16] = fb16s[16][i];
        fb16t[mul + 17] = fb16s[17][i];
        fb16t[mul + 18] = fb16s[18][i];
        fb16t[mul + 19] = fb16s[19][i];
        fb16t[mul + 20] = fb16s[20][i];
        fb16t[mul + 21] = fb16s[21][i];
        fb16t[mul + 22] = fb16s[22][i];
        fb16t[mul + 23] = fb16s[23][i];
        fb16t[mul + 24] = fb16s[24][i];
        fb16t[mul + 25] = fb16s[25][i];
        fb16t[mul + 26] = fb16s[26][i];
        fb16t[mul + 27] = fb16s[27][i];
        fb16t[mul + 28] = fb16s[28][i];
        fb16t[mul + 29] = fb16s[29][i];
        fb16t[mul + 30] = fb16s[30][i];
        fb16t[mul + 31] = fb16s[31][i];
    }
}

void
mixer_unity_mux_1to1_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
    }
}

void
mixer_unity_mux_2to2_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
    }
}

void
mixer_unity_mux_3to3_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
    }
}

void
mixer_unity_mux_4to4_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
    }
}

void
mixer_unity_mux_5to5_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
    }
}

void
mixer_unity_mux_6to6_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
    }
}

void
mixer_unity_mux_7to7_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
    }
}

void
mixer_unity_mux_8to8_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
    }
}

void
mixer_unity_mux_9to9_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
    }
}

void
mixer_unity_mux_10to10_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
    }
}

void
mixer_unity_mux_11to11_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
    }
}

void
mixer_unity_mux_12to12_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
    }
}

void
mixer_unity_mux_13to13_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
    }
}

void
mixer_unity_mux_14to14_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
    }
}

void
mixer_unity_mux_15to15_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
    }
}

void
mixer_unity_mux_16to16_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
    }
}

void
mixer_unity_mux_17to17_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
    }
}

void
mixer_unity_mux_18to18_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
    }
}

void
mixer_unity_mux_19to19_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
    }
}

void
mixer_unity_mux_20to20_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
    }
}

void
mixer_unity_mux_21to21_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
    }
}

void
mixer_unity_mux_22to22_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
    }
}

void
mixer_unity_mux_23to23_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
    }
}

void
mixer_unity_mux_24to24_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
    }
}

void
mixer_unity_mux_25to25_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
        fb32t[mul + 24] = fb32s[24][i];
    }
}

void
mixer_unity_mux_26to26_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
        fb32t[mul + 24] = fb32s[24][i];
        fb32t[mul + 25] = fb32s[25][i];
    }
}

void
mixer_unity_mux_27to27_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
        fb32t[mul + 24] = fb32s[24][i];
        fb32t[mul + 25] = fb32s[25][i];
        fb32t[mul + 26] = fb32s[26][i];
    }
}

void
mixer_unity_mux_28to28_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
        fb32t[mul + 24] = fb32s[24][i];
        fb32t[mul + 25] = fb32s[25][i];
        fb32t[mul + 26] = fb32s[26][i];
        fb32t[mul + 27] = fb32s[27][i];
    }
}

void
mixer_unity_mux_29to29_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
        fb32t[mul + 24] = fb32s[24][i];
        fb32t[mul + 25] = fb32s[25][i];
        fb32t[mul + 26] = fb32s[26][i];
        fb32t[mul + 27] = fb32s[27][i];
        fb32t[mul + 28] = fb32s[28][i];
    }
}

void
mixer_unity_mux_30to30_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
        fb32t[mul + 24] = fb32s[24][i];
        fb32t[mul + 25] = fb32s[25][i];
        fb32t[mul + 26] = fb32s[26][i];
        fb32t[mul + 27] = fb32s[27][i];
        fb32t[mul + 28] = fb32s[28][i];
        fb32t[mul + 29] = fb32s[29][i];
    }
}

void
mixer_unity_mux_31to31_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
        fb32t[mul + 24] = fb32s[24][i];
        fb32t[mul + 25] = fb32s[25][i];
        fb32t[mul + 26] = fb32s[26][i];
        fb32t[mul + 27] = fb32s[27][i];
        fb32t[mul + 28] = fb32s[28][i];
        fb32t[mul + 29] = fb32s[29][i];
        fb32t[mul + 30] = fb32s[30][i];
    }
}

void
mixer_unity_mux_32to32_32(mixer *m,
                frame_bits_t fb_target,
                frame_bits_t *fb_sources,
                int frame_width,
                long frame_count) {
    register int i, mul;
    int32_t *fb32t = (int32_t *)fb_target, **fb32s = (int32_t **)fb_sources;

    for(i = 0; i < frame_count; i++) {
        mul = i * m->target_channels;
        
        fb32t[mul + 0] = fb32s[0][i];
        fb32t[mul + 1] = fb32s[1][i];
        fb32t[mul + 2] = fb32s[2][i];
        fb32t[mul + 3] = fb32s[3][i];
        fb32t[mul + 4] = fb32s[4][i];
        fb32t[mul + 5] = fb32s[5][i];
        fb32t[mul + 6] = fb32s[6][i];
        fb32t[mul + 7] = fb32s[7][i];
        fb32t[mul + 8] = fb32s[8][i];
        fb32t[mul + 9] = fb32s[9][i];
        fb32t[mul + 10] = fb32s[10][i];
        fb32t[mul + 11] = fb32s[11][i];
        fb32t[mul + 12] = fb32s[12][i];
        fb32t[mul + 13] = fb32s[13][i];
        fb32t[mul + 14] = fb32s[14][i];
        fb32t[mul + 15] = fb32s[15][i];
        fb32t[mul + 16] = fb32s[16][i];
        fb32t[mul + 17] = fb32s[17][i];
        fb32t[mul + 18] = fb32s[18][i];
        fb32t[mul + 19] = fb32s[19][i];
        fb32t[mul + 20] = fb32s[20][i];
        fb32t[mul + 21] = fb32s[21][i];
        fb32t[mul + 22] = fb32s[22][i];
        fb32t[mul + 23] = fb32s[23][i];
        fb32t[mul + 24] = fb32s[24][i];
        fb32t[mul + 25] = fb32s[25][i];
        fb32t[mul + 26] = fb32s[26][i];
        fb32t[mul + 27] = fb32s[27][i];
        fb32t[mul + 28] = fb32s[28][i];
        fb32t[mul + 29] = fb32s[29][i];
        fb32t[mul + 30] = fb32s[30][i];
        fb32t[mul + 31] = fb32s[31][i];
    }
}
