/*
**  MessageViewWindowController.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ujwal S. Sathyam <ujwal@setlurgroup.com>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_MessageViewWindowController
#define _GNUMail_H_MessageViewWindowController

#import <AppKit/AppKit.h>

@class Message;
@class Folder;
@class MailHeaderCell;
@class MailWindowController;

@interface MessageViewWindowController : NSWindowController
{
    IBOutlet NSTextView *textView;
#ifdef MACOSX
    IBOutlet NSView *navigationView;
#endif

    Message *message;                            // the message that will be displayed
    Folder *folder;                              // the folder this message lives in
    MailWindowController *mailWindowController;  // the owning/parent mail window controller
    BOOL showAllHeaders;                         // flag to show all email headers
    BOOL showRawSource;                          // flag to show raw source
    int indexOffset;                             // offset to our initial index
    MailHeaderCell *mailHeaderCell;              // cell in which we display the headers
    

    @public
      IBOutlet NSButton *previousMessage;
      IBOutlet NSButton *nextMessage;
      IBOutlet NSButton *showOrHideAllHeaders;
      IBOutlet NSButton *raw;
}

- (id) initWithWindowNibName: (NSString *) theWindowNibName;
- (void)dealloc;


//
// action methods
//
- (IBAction) deleteMessage: (id) sender;
- (IBAction) replyMessage: (id) sender;
- (IBAction) forwardMessage: (id) sender;
- (IBAction) previousMessage: (id) sender;
- (IBAction) nextMessage: (id) sender;
- (IBAction) firstMessage: (id) sender;
- (IBAction) lastMessage: (id) sender;
- (IBAction) showOrHideAllHeaders: (id) sender;


//
// delegate methods
//
- (void) windowWillClose: (NSNotification *) theNotification;
- (void) windowDidLoad;
- (void) windowDidBecomeKey: (NSNotification *) aNotification;


//
// access/mutation methods
//
- (NSTextView *) textView;
- (Message *) message;
- (Message *) selectedMessage;
- (void) setMessage:(Message *)aMessage;
- (Folder *) folder;
- (void) setFolder:(Folder *) aFolder;
- (MailWindowController *) mailWindowController;
- (void) setMailWindowController: (MailWindowController *)aMailWindowController;
- (BOOL) showAllHeaders;
- (void) setShowAllHeaders: (BOOL) aBool;
- (BOOL) showRawSource;
- (void) setShowRawSource: (BOOL) aBool;
- (MailHeaderCell *) mailHeaderCell;
- (int) indexOffset;
- (void) setIndexOffset: (int) theIndexOffset;


//
// other methods
//
-  (void) textView: (NSTextView *) aTextView
     clickedOnCell: (id <NSTextAttachmentCell>) attachmentCell
	    inRect: (NSRect) cellFrame
           atIndex: (unsigned) charIndex;

- (BOOL) textView: (NSTextView *) textView
    clickedOnLink: (id) link 
	  atIndex: (unsigned) charIndex;



@end


//
// Private interface
//
@interface MessageViewWindowController (Private)

- (void) _loadAccessoryViews;

@end

#endif // _GNUMail_H_MessageViewWindowController
