/*
**  EditWindow.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_EditWindow
#define _GNUMail_H_EditWindow

#import <AppKit/AppKit.h>

@class AutoCompletingTextField;
@class ExtendedTextView;
@class LabelWidget;

@interface EditWindow : NSWindow
{
  @public
    AutoCompletingTextField *toText;
    AutoCompletingTextField *ccText;
    AutoCompletingTextField *bccText;
    ExtendedTextView *textView;
    NSTextField *subjectText;
    
    LabelWidget *fromLabel;
    LabelWidget *usingLabel;
    LabelWidget *toLabel;
    LabelWidget *ccLabel;
    LabelWidget *bccLabel;
    LabelWidget *subjectLabel;
    LabelWidget *sizeLabel;
    
    NSScrollView *scrollView;
    
    NSButton *send;
    NSButton *insert;
    NSButton *addCc;
    NSButton *addBcc;
    NSButton *addresses;
    
    NSPopUpButton *accountPopUpButton;
    NSPopUpButton *transportMethodPopUpButton;
}

- (void) dealloc;
- (void) layoutWindow;

@end

#endif // _GNUMail_H_EditWindow

