#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GRLayout.py
#
# DESCRIPTION:
# Classes related to the Layout section
#
# NOTES:
#


from gnue.common.apps import GDebug
from xml.sax import saxutils
from ContainerElement import ContainerElement


############################################################
#
# Any namespaced tags designed to
# simply pass thru our layout engine
#
class GRPassThru(ContainerElement):
  def __init__(self, parent):
    ContainerElement.__init__(self, parent, 'GRPassThru')

  def process(self, dest, mapper, isfirst, islast, firstSection, nextSection):
    dest.write('<%s' % self._xmltag)
    for attr in self._loadedxmlattrs.keys():
      dest.write(' %s="%s"' % (attr, saxutils.escape(str(self._loadedxmlattrs[attr]))))

    if len(self._children):
      dest.write('>')
      nextSection = self.processChildren(dest, mapper, isfirst, islast, firstSection, nextSection)
      dest.write('</%s>' % self._xmltag)
    else:
      dest.write('/>')

    return nextSection

  def getXmlTag(self):
    return self._xmltag

