#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# $Id: CHReport.py 6706 2004-11-22 12:26:58Z btami $
#
# DESCRIPTION:
# Class that contains xml objects for GNUe Reports'
# "Char" markup.
#
# NOTES:
#

__all__ = ['CHReport']


from gnue.common.definitions.GObjects import GObj
from gnue.common.definitions.GRootObj import GRootObj
from gnue.common.apps import GDebug
import CHParser


class CHReport(GRootObj, GObj): 
  def __init__(self, parent=None):
    GRootObj.__init__(self, 'report', CHParser.getXMLelements, CHParser)
    GObj.__init__(self, parent, type='CHReport')


  def process(self, writer):
    writer.PageHeader = self.findChildOfType('CHPageHeader')
    writer.PageFooter = self.findChildOfType('CHPageFooter')

    TitlePage = self.findChildOfType('CHTitlePage')
    if TitlePage:
      TitlePage.process(writer)

    for child in self._children:
      if child._type in ('CHDetail', 'CHGroupHeader', 'CHGroupFooter'):
        child.process(writer)

    SummaryPage = self.findChildOfType('CHSummaryPage')
    if SummaryPage:
      SummaryPage.process(writer)

    if writer.PageFooter and (not writer.pageFooterDone):
      writer.PageFooter.process(writer)
    writer.newPage()
