/* vi:set ts=8 sts=0 sw=8:
 * $Id: file.h,v 1.15 2000/03/31 04:39:34 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __FILE_H__
#define __FILE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include <sys/stat.h>
#include "main.h"
#include "win.h"
#include "doc.h"

#define OPEN_NO_ERROR	(1 << 0)
#define OPEN_EXCL	(1 << 1)
#define OPEN_NO_LOCK	(1 << 2)

#ifdef USE_GNOME
# define file_exist(fname)	g_file_exists(fname)
#else
extern bool_t file_exist(char *fname);
#endif
extern void file_close_fp(const char *fname, FILE *fp);
extern FILE * file_open_fp(const char *fname, const char *fmode, int flags,
			   const char *func);
extern int file_open_execute(doc_t *d);
extern char *file_perm_string(struct stat *sb);
extern bool_t file_save_execute(doc_t *d, bool_t saveas);
extern char * file_full_pathname_make(char *fname);
extern int file_unlock(const char *path, FILE *fp);
extern int file_lock(const char *, FILE *fp, bool_t, bool_t, bool_t);
extern bool_t file_is_readonly(doc_t *d);
extern struct stat *file_get_stats(char *fname);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __FILE_H__ */
