/******************************************************************************\
 gnofin/dialog-order-account.c   $Revision: 1.1 $
 Copyright (C) 2000 Luc Saillard <luc.saillard@alcove.fr>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include "ui.h"
#include <gtk/gtksignal.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtkclist.h>
#include <gtk/gtklabel.h>
#include <libgnomeui/gnome-dialog.h>
#include <libgnomeui/gnome-stock.h>
#include <data-structure/data-if.h>
#include "dialogs.h"
#include "data-events.h"

typedef struct 
{
  GtkWidget *window;
  GtkCList  *clist;
  GtkWidget *up;
  GtkWidget *down;
  GtkWidget *remove;

  gint selected_row;
  UI *ui;

} DialogInfo;



static void
on_select_row (GtkCList *clist, gint row, gint col, GdkEventButton *event, DialogInfo *info)
{
  gint numrows = clist->rows;

  if (numrows)
   {
     info->selected_row = row;

     gtk_widget_set_sensitive (info->up, (row>0));
     gtk_widget_set_sensitive (info->down, (row+1<numrows));
     gtk_widget_set_sensitive (info->remove, (numrows>0));

     gtk_notebook_set_page (GTK_NOTEBOOK (info->ui->notebook), row);
  }
  else
   {
     info->selected_row = -1;
     gtk_widget_set_sensitive (info->up, FALSE);
     gtk_widget_set_sensitive (info->down, FALSE);
     gtk_widget_set_sensitive (info->remove, FALSE);
   }
}

static void
on_unselect_row (GtkWidget *w, gint row, gint col, GdkEventButton *event, DialogInfo *info)
{
  info->selected_row = -1;
  gtk_widget_set_sensitive (info->up, FALSE);
  gtk_widget_set_sensitive (info->down, FALSE);
  gtk_widget_set_sensitive (info->remove, FALSE);
}

static void
on_remove_row (GtkButton *button, DialogInfo *info)
{
  if (info->selected_row>=0)
   {
     ui_remove_current_account(info->ui);
     gtk_clist_remove(info->clist,info->selected_row);
     on_unselect_row(NULL,0,0,NULL,info);
   }
}

static void
on_row_move (GtkCList *clist, gint src, gint dest, DialogInfo *info)
{
  trace ("");

  if_bankbook_enter_batch_mode(info->ui->book);
  info->selected_row = dest;
  if_bankbook_leave_batch_mode(info->ui->book);
}

static void
on_move_up (GtkButton *button, DialogInfo *info)
{
  GList *list;
  gpointer *data;
  GtkWidget *w;

  if (info->selected_row>=0)
   {
     list=g_list_nth((GList *)if_bankbook_get_accounts (info->ui->book),info->selected_row);
     data=list->prev->data;
     list->prev->data=list->data;
     list->data=data;
     
     w = gtk_notebook_get_nth_page(info->ui->notebook,info->selected_row);
     gtk_notebook_reorder_child(info->ui->notebook,w,info->selected_row - 1);
     gtk_clist_row_move (info->clist, info->selected_row, info->selected_row - 1);
     on_select_row (info->clist,info->selected_row, 0, NULL, info);
   }
}

static void
on_move_down (GtkButton *button, DialogInfo *info)
{
  GList *list;
  gpointer *data;
  GtkWidget *w;

  if (info->selected_row>=0)
   {
     /* Swap account pointer in the list */
     list=g_list_nth((GList *)if_bankbook_get_accounts (info->ui->book),info->selected_row);
     data=list->next->data;
     list->next->data=list->data;
     list->data=data;

     /* Swap notebook tabs */
     w = gtk_notebook_get_nth_page(info->ui->notebook,info->selected_row);
     gtk_notebook_reorder_child(info->ui->notebook,w,info->selected_row + 1);

     /* Swap row in the Clist */
     gtk_clist_row_move (info->clist, info->selected_row, info->selected_row + 1);
     on_select_row (info->clist,info->selected_row, 0, NULL, info);
   }
}

guint
dialog_order_account (GtkWindow *parent, UI *ui)
{
  const GList *ac;
  const Account *account;
  GtkWidget *window;
  static DialogInfo *info=NULL;
  GtkWidget *button, *label;
  GtkWidget *scrolledwindow;
  GtkWidget *hbox, *vbox;
  GtkCList  *clist;
  int i;

  trace("");

  if (!info)
   {
     info = g_new0 (DialogInfo,1);
   }

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  info->window=window;
  gtk_window_set_title ((GtkWindow *)window,_("Order Accounts"));
  gtk_window_set_modal ((GtkWindow *)window,TRUE);

  hbox = gtk_hbox_new(FALSE,0);
  gtk_container_add (GTK_CONTAINER (window), hbox);

  /* Build the left part (list of account) */
  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_box_pack_start (GTK_BOX (hbox), scrolledwindow, TRUE, TRUE, 0);

  clist = (GtkCList *)gtk_clist_new (1);
  info->clist=clist;
  gtk_widget_set_usize ((GtkWidget *)clist, 260, 200);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), (GtkWidget *)clist);
  gtk_clist_column_titles_show (clist);
  gtk_clist_set_column_auto_resize (clist, 0, TRUE);

  label = gtk_label_new (_("Account"));
  gtk_clist_set_column_widget (clist, 0, label);

  gtk_clist_freeze (clist);
  ac = if_bankbook_get_accounts (ui->book);
  for (i=0; ac; ac=ac->next, i++)
   {
     const char *name;
     int position;

     account = LIST_DEREF (Account, ac);
     name = if_account_get_name (account);
     position = if_account_get_index (account);
     gtk_clist_insert(clist,position,(char **)&name);
   }
  gtk_clist_thaw (clist);

  gtk_signal_connect (GTK_OBJECT (clist), "select_row",
      GTK_SIGNAL_FUNC (on_select_row),info);

  gtk_signal_connect (GTK_OBJECT (clist), "unselect_row",
      GTK_SIGNAL_FUNC (on_unselect_row), info);

  gtk_signal_connect (GTK_OBJECT (clist), "row_move",
      GTK_SIGNAL_FUNC (on_row_move), info);

  /* Build the right part (with button) */
  vbox = gtk_vbox_new(TRUE,0);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);

  button = gnome_stock_button(GNOME_STOCK_BUTTON_UP);
  info->up=button;
  gtk_widget_set_sensitive (button, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
      GTK_SIGNAL_FUNC (on_move_up), info);

  button = gnome_stock_button(GNOME_STOCK_BUTTON_DOWN);
  info->down=button;
  gtk_widget_set_sensitive (button, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
      GTK_SIGNAL_FUNC (on_move_down), info);

  button = gnome_stock_button(GNOME_STOCK_PIXMAP_REMOVE);
  info->remove=button;
  gtk_widget_set_sensitive (button, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
      GTK_SIGNAL_FUNC (on_remove_row), info);

  button = gnome_stock_button(GNOME_STOCK_BUTTON_CLOSE);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
      GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)window);

  info->ui=ui;
  info->selected_row=-1;

  if (!GTK_WIDGET_VISIBLE (info->window))
   {
     gtk_widget_show_all (info->window);
   }

  return TRUE;
}
