/* gnobog_menu.c
 *
 * Copyright (C) 2000 Frdric LESPEZ  & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include "gnobog_open_file_dialog.h"
#include "gnobog_menus.h"
#include "gnobog_app.h"

static void gnobog_menus_nothing_cb (GtkWidget* widget, gpointer data);
static void gnobog_menus_new_doc_cb (GtkWidget* widget, gpointer data);
static void gnobog_menus_close_all_cb (GtkWidget* widget, gpointer data);
static void gnobog_menus_exit_cb (GtkWidget* widget, gpointer data);
static void gnobog_menus_about_cb (GtkWidget* widget, gpointer data);
static void gnobog_menus_preferences_cb (GtkWidget* widget, gpointer data);






/*****************************************************************************/
/* Menus definitions                                                         */
/*****************************************************************************/

/* Save and save as are done with the popup in each document
 * as in gimp.
 * Closing one document is also done with the popup
 */
static GnomeUIInfo file_menu [] = {
  GNOMEUIINFO_MENU_NEW_ITEM   (N_("_New Document"), 
			       N_("Create a new Document"), 
			       gnobog_menus_new_doc_cb, 
			       NULL),
  GNOMEUIINFO_MENU_OPEN_ITEM  (gnobog_ui_open_file, 
			       NULL),

  GNOMEUIINFO_SEPARATOR,

  GNOMEUIINFO_ITEM_NONE       (N_("_Close All"), 
			       N_("Close All Documents"), 
			       gnobog_menus_close_all_cb),
  GNOMEUIINFO_MENU_EXIT_ITEM  (gnobog_menus_exit_cb, 
			       NULL),
  GNOMEUIINFO_END
};


static GnomeUIInfo help_menu [] = {
  GNOMEUIINFO_HELP            ("gnobog"),
  GNOMEUIINFO_MENU_ABOUT_ITEM (gnobog_menus_about_cb, 
			       NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo menu [] = {
  GNOMEUIINFO_MENU_FILE_TREE  (file_menu),
  GNOMEUIINFO_MENU_HELP_TREE  (help_menu),
  GNOMEUIINFO_END
};


/*  static GnomeUIInfo toolbar [] = { */
/*    GNOMEUIINFO_ITEM_STOCK (N_("Open"),  */
/*  			  N_("Open a Document"),  */
/*  			  gnobog_ui_open_file,  */
/*  			  GNOME_STOCK_PIXMAP_OPEN), */
/*    GNOMEUIINFO_ITEM_STOCK (N_("New"),  */
/*  			  N_("Create a new Document"),  */
/*  			  gnobog_menus_new_doc_cb,  */
/*  			  GNOME_STOCK_PIXMAP_NEW), */
/*    GNOMEUIINFO_ITEM_STOCK (N_("Quit"),  */
/*  			  N_("Quit Gnobog"),  */
/*  			  gnobog_menus_exit_cb,  */
/*  			  GNOME_STOCK_PIXMAP_EXIT), */

/*    GNOMEUIINFO_SEPARATOR, */

/*    GNOMEUIINFO_ITEM_STOCK (N_("Pref"),  */
/*  			  N_("Set user's preferences"),  */
/*  			  gnobog_menus_preferences_cb,  */
/*  			  GNOME_STOCK_PIXMAP_PREFERENCES), */
/*    GNOMEUIINFO_END */
/*  }; */



/*****************************************************************************/
/* Menus and toolbar creation                                                */
/*****************************************************************************/

void 
gnobog_menus_install_menus_and_toolbar(GtkWidget* app)
{
   GtkWidget*  pixmapwid;
   GtkWidget*  toolbar;
 
   toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
   gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NONE);
   gtk_container_set_border_width (GTK_CONTAINER (toolbar), 2);
   gtk_widget_show (toolbar);

   pixmapwid = gnome_stock_pixmap_widget (app, GNOME_STOCK_PIXMAP_OPEN);
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 0, _("Open a Document"), 0, pixmapwid, GTK_SIGNAL_FUNC (gnobog_ui_open_file), app);

   pixmapwid = gnome_stock_pixmap_widget (app, GNOME_STOCK_PIXMAP_NEW);
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 0, _("Create a new Document"), 0, pixmapwid, GTK_SIGNAL_FUNC (gnobog_menus_new_doc_cb), app);

   pixmapwid = gnome_stock_pixmap_widget (app, GNOME_STOCK_PIXMAP_EXIT);
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 0, _("Quit Gnobog"), 0, pixmapwid, GTK_SIGNAL_FUNC (gnobog_menus_exit_cb), app);

   gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
   gtk_toolbar_set_space_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_SPACE_LINE);

   pixmapwid = gnome_stock_pixmap_widget (app, GNOME_STOCK_PIXMAP_PREFERENCES);
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 0, _("Set user's preferences"), 0, pixmapwid, GTK_SIGNAL_FUNC (gnobog_menus_preferences_cb), app);

   gnome_app_add_docked (GNOME_APP (app), toolbar, "Toolbar", /* GNOME_DOCK_ITEM_BEH_NORMAL */ GNOME_DOCK_ITEM_BEH_EXCLUSIVE, GNOME_DOCK_TOP, 2, 1, 0);                             

   //  gnome_app_create_toolbar_with_data (GNOME_APP(app), toolbar, app);
  gnome_app_create_menus_with_data (GNOME_APP(app), menu, app);
  gnome_app_install_menu_hints (GNOME_APP(app), menu);
}












/*****************************************************************************/
/* Menus callbacks                                                           */
/*****************************************************************************/

static void 
gnobog_menus_nothing_cb (GtkWidget* widget, 
			 gpointer data)
{
  GtkWidget* dialog;
  GtkWidget* app;
  
  app = (GtkWidget*) data;

  dialog = gnome_ok_dialog_parented (_("This does nothing; it is only a demonstration."),
				     GTK_WINDOW(app));
}

static void 
gnobog_menus_new_doc_cb (GtkWidget* widget, 
			 gpointer data)
{
  gnobog_app_document_new ();
}




static void 
gnobog_menus_close_all_cb (GtkWidget* widget, 
			   gpointer data)
{
  gnobog_app_document_close_all ( );
}

static void 
gnobog_menus_exit_cb (GtkWidget* widget, 
		      gpointer data)
{
  GtkWidget* app;

  app = (GtkWidget*) data;

  gnobog_app_quit (app /* main app window */);
}

static void 
gnobog_menus_about_cb (GtkWidget* widget, 
		       gpointer data)
{
  static GtkWidget*  dialog = NULL;
  GtkWidget*         homepage;
  GtkWidget*         hbox;
  GtkWidget*         app;

  app = (GtkWidget*) data;

  if (dialog != NULL) {
    g_assert (GTK_WIDGET_REALIZED (dialog));
    gdk_window_show (dialog->window);
    gdk_window_raise (dialog->window);
  } else {        
    const gchar *authors[] = {
      "Chaillat Renaud <renaud_chaillat@netcourrier.com>",
      "Lespez Frederic <frederic.lespez@wanadoo.fr>",
      NULL
    };

    dialog = gnome_about_new (_("Gnobog"), VERSION,
			      "(C) 2000, Frederic Lespez & Renaud Chaillat",
			      authors,
			      _("A GNOME bookmarks organizer and web surfing helper."),
                                /* logo */ GNOBOG_PIXMAPSDIR "/gnobog-logo.png");

    /* hbox in case we want to add more things later on */
    hbox     = gtk_hbox_new (TRUE, 0);
    homepage = gnome_href_new ("http://gnobog.sourceforge.net/",
			       _("Gnobog Home Page"));
    gtk_box_pack_start (GTK_BOX (hbox), homepage, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox),
			hbox, TRUE, FALSE, 0);
    gtk_widget_show_all (hbox);

    gtk_signal_connect (GTK_OBJECT (dialog),
			"destroy",
			GTK_SIGNAL_FUNC (gtk_widget_destroyed),
			&dialog);

    gnome_dialog_set_parent (GNOME_DIALOG (dialog), GTK_WINDOW (app));

    gtk_widget_show (dialog);
  }
}

/* Change selection mode in all arborescences */
static void
gnobog_menus_preferences_cb (GtkWidget* widget, gpointer data)
{
  gnome_ok_dialog(_("Nothing yet..."));

}



/**************************************************************************/
/****  Utils                                                            ***/
/**************************************************************************/


/* TODO: should be here ? */
GtkWidget*
gnobog_menus_get_menu_item_from_path (GtkWidget* menu,
				      const gchar* path)
{
  GtkWidget*    parent_menu_widget;
  GtkMenuShell* parent_menu_shell;
  GtkWidget*    menu_item;
  gint          pos;

  /* TODO: make gtk-only equivalent */

  parent_menu_widget = NULL;
  menu_item          = NULL;
  parent_menu_widget = gnome_app_find_menu_pos (menu, path, &pos);
  if (! parent_menu_widget) {
    g_message ("Can't find menu entry '%s'! i18n problem ?", 
	       path);
  } else {
    //    g_message ("Found menu entry '%s' at pos %d !\n", path, pos);
    parent_menu_shell = GTK_MENU_SHELL (parent_menu_widget);
    menu_item         = GTK_WIDGET (g_list_nth (parent_menu_shell->children, pos-1)->data);
  }

  return menu_item;
}



/* gnobog-menus ***/
