#include "parse.h"
#include "socket.h"
#include "request.h"
#include "system.h"

Request_Struct req;

int Handle_Request(char *line)
{
	memset(&req, 0, sizeof(req));
	
	if(!line) return(-1);
	if(Parse_Request(line, &req.lp, &req.rp)) {
		Reply_Error("INVALID-PORT");
		return(-1);
	}
		
	switch(ipversion) {
	case 4:
		req.uid=tcp4();
		break;
	case 6:
		req.uid=tcp6();
		if(req.uid<0) req.uid=tcp4();
		break;
	default:
		req.uid=-1;
		break;
	}
	
	switch(req.uid) {
	case -1:
		Reply_Error("UNKNOWN-ERROR");
		break;
	case -2:
		Reply_Error("NO-USER");
		break;
	default:
		if(UserInfo(req.uid, &req.name, &req.home)) 
			Reply_Error("UNKNOWN-ERROR");
		else
			Reply_User(req.name);
		break;
	}
	return(0);
}

