// T3MM2DOCV.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3mm2docv.h"

#include "geomopt_dialog.h"
#include "moldyn_dialog.h"
#include "trajview_dialog.h"

#include "t3main.h"
#include "t3dialog.h"
#include "t3errutil.h"
#include "t3views.h"

#include "mm2rbn.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include "mm1mdl.h"

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

const char mm2_file_open_dialog::title[] = "Open Project File - mm2gp";
gnome_mm2_docv * mm2_file_open_dialog::docv = NULL;

mm2_file_open_dialog::mm2_file_open_dialog(gnome_mm2_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

mm2_file_open_dialog::~mm2_file_open_dialog(void)
{
}

bool mm2_file_open_dialog::OkEvent(const char * filename)
{
	if (docv == NULL)
	{
		docv = new gnome_mm2_docv(& cout, * gnome_class_factory::GetInstance(), NULL);
		docv->InitGnomeMDIChild();
	}
	
	ifstream ifile;
	ifile.open(filename, ios::in);
	docv->ReadStream(ifile, false);
	ifile.close();
	
	docv->ParseProjectFileNameAndPath(filename);
	
	gnome_mdi_child_set_name(GNOME_MDI_CHILD(docv->child), docv->GetProjectFileName(true));
	docv->UpdateAllWindowTitles();
	
	docv->UpdateAllGraphicsViews();
	
	return true;
}

void mm2_file_open_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

const char mm2_file_save_dialog::title[] = "Save Project File - mm2gp";
gnome_mm2_docv * mm2_file_save_dialog::docv = NULL;

mm2_file_save_dialog::mm2_file_save_dialog(gnome_mm2_docv * p1) :
	file_dialog(title, MM2_FILTER, p1->GetFullProjectFileName())
{
	docv = p1;
}

mm2_file_save_dialog::~mm2_file_save_dialog(void)
{
}

bool mm2_file_save_dialog::OkEvent(const char * filename)
{
	if (docv == NULL)
	{
	  docv->err->ErrorMessage("mm2_file_save_dialog::OkEvent() failed");
	  exit(EXIT_FAILURE);
	}
	
  	// should check to see if file already exists...

	docv->ParseProjectFileNameAndPath(filename);
	
	gnome_mdi_child_set_name(GNOME_MDI_CHILD(docv->child), docv->GetProjectFileName(true));
	docv->UpdateAllWindowTitles();
	
	ofstream ofile;
	ofile.open(docv->GetFullProjectFileName(), ios::out);
	docv->WriteStream(ofile);
	ofile.close();

	return true;
}

void mm2_file_save_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

const char mm2_trajfile_dialog::title[] = "Open Trajectory File - traj";
mm2_docv * mm2_trajfile_dialog::docv = NULL;

mm2_trajfile_dialog::mm2_trajfile_dialog(mm2_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

mm2_trajfile_dialog::~mm2_trajfile_dialog(void)
{
}

bool mm2_trajfile_dialog::OkEvent(const char * filename)
{
	docv->OpenTrajectory(filename);
	
	gtk_widget_destroy(dialog);	// close the dialog -> must return false...
	
	gnome_docv::glade_modal_dialog_owner = (gnome_mm2_docv *) docv;		// requires modal dialogs!!!
	
	new trajview_dialog();	// will call delete and CloseTrajectory!
	//GtkWidget * dialog = create_t1_dialog_trajectory();	// obsolete
	//gnome_dialog_run_and_close(GNOME_DIALOG(dialog));	// obsolete
	//docv->CloseTrajectory();			// is handled by dialog...
	
	return false;
}

void mm2_trajfile_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

const char mm2_importpdb_dialog::title[] = "Import File - Brookhaven PDB/ENT";
gnome_mm2_docv * mm2_importpdb_dialog::docv = NULL;

mm2_importpdb_dialog::mm2_importpdb_dialog(gnome_mm2_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

mm2_importpdb_dialog::~mm2_importpdb_dialog(void)
{
}

bool mm2_importpdb_dialog::OkEvent(const char * filename)
{
	if (docv != NULL)
	{
		docv->err->WarningMessage("This alternative PDB reader is designed to remove any gaps that might exist in the structure data.\nTherefore the sequence might be altered! The process can also take several minutes to complete.");
		
		docv->ParseProjectFileNameAndPath(filename);
		
//cout << "give name of the PDB file to import ??? "; cin >> docv->buffer;
//cout << "give the chain index to be imported, or -1 to import all chains ??? "; i32s ci; cin >> ci;
//docv->ImportPDB(docv->buffer, ci);

		docv->ImportPDB(filename, -1);
		
		docv->UpdateAllWindowTitles();
		docv->UpdateAllGraphicsViews();
	}
	
	return true;
}

void mm2_importpdb_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

GnomeUIInfo gnome_mm2_docv::filext_submenu[] =
{
	GNOMEUIINFO_ITEM("Import PDB...", "a special tool for importing PDB files.",
		popup_FileExtra1, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::file_submenu[] =
{
	GNOMEUIINFO_MENU_OPEN_ITEM(popup_FileOpen, NULL),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_SAVE_AS_ITEM(popup_FileSaveAs, NULL),
	
	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_SUBTREE("Extra Tools", filext_submenu),

	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_CLOSE_ITEM(gnome_graphics_view::popup_FileClose, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::select_submenu[] =
{
	GNOMEUIINFO_ITEM("Select All", "select all atoms...",
		gnome_graphics_view::popup_SelectAll, NULL),
		
	GNOMEUIINFO_ITEM("Invert Selection", "invert the selection...",
		gnome_graphics_view::popup_InvertSelection, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::viewscreate_submenu[] =
{
	GNOMEUIINFO_ITEM("New Camera", "create a new view with a new camera...",
		gnome_graphics_view::popup_ViewsNewCam, NULL),
	
	GNOMEUIINFO_ITEM("New View", "create a new view using the current camera...",
		gnome_graphics_view::popup_ViewsNewView, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::views_submenu[] =
{
	GNOMEUIINFO_ITEM("Attach/Detach This View", "attach/detach this view...",
		gnome_graphics_view::popup_ViewsAttachDetach, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Create", viewscreate_submenu),
	
	GNOMEUIINFO_ITEM("Delete This View", "remove this view...",
		gnome_graphics_view::popup_ViewsDeleteView, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::lights_submenu[] =
{
	GNOMEUIINFO_ITEM("Create New Light", "create a new light object...",
		gnome_graphics_view::popup_LightsNewLight, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_TOGGLEITEM("Enable Local Lights", "loc",
		gnome_graphics_view::popup_LightsSwitchLoc, NULL),
		
	GNOMEUIINFO_TOGGLEITEM("Enable Global Lights", "glob",
		gnome_graphics_view::popup_LightsSwitchGlob, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::rendermode_style_radio[] =
{
	GNOMEUIINFO_ITEM("Ball & Stick", "bs",
		popup_RModeBallAndStick, NULL),
		
	GNOMEUIINFO_ITEM("Wireframe", "wf",
		popup_RModeWireFrame, NULL),
		
	GNOMEUIINFO_ITEM("van der Waals", "vdw",
		popup_RModeVanDerWaals, NULL),
		
	GNOMEUIINFO_ITEM("Solvent-Accessible", "sas",
		popup_RModeAccessible, NULL),
		
	GNOMEUIINFO_ITEM("Cylinders", "cyl",
		popup_RModeCylinders, NULL),
		
	GNOMEUIINFO_ITEM("Nothing", "null",
		popup_RModeNothing, NULL),

	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::rendermode_color_radio[] =
{
	GNOMEUIINFO_ITEM("Color State", "color-st",
		popup_CModeState, NULL),
		
	GNOMEUIINFO_ITEM("Color Residue", "color-res",
		popup_CModeResidue, NULL),
		
	GNOMEUIINFO_ITEM("Color SASA", "color-sasa",
		popup_CModeSASA, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::rendermode_label_radio[] =
{
	GNOMEUIINFO_ITEM("Label Nothing", "lab-null",
		popup_LModeNothing, NULL),
		
	GNOMEUIINFO_ITEM("Label Residue", "lab-res",
		popup_LModeResidue, NULL),

//	GNOMEUIINFO_ITEM("Label DEBUG", "lab-???",
//		popup_LModeDEBUG, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::rendermode_submenu[] =
{
        GNOMEUIINFO_RADIOLIST(rendermode_style_radio),
	GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_RADIOLIST(rendermode_color_radio),
	GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_RADIOLIST(rendermode_label_radio),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::projection_radio[] =
{
	GNOMEUIINFO_ITEM("Perspective", "persp",
		gnome_graphics_view::popup_ProjPerspective, NULL),
		
	GNOMEUIINFO_ITEM("Orthographic", "ortho",
		gnome_graphics_view::popup_ProjOrthographic, NULL),

	GNOMEUIINFO_ITEM("Red-Green Stereo", "redgre",
		gnome_graphics_view::popup_ProjRedGreen, NULL),
		
	GNOMEUIINFO_ITEM("Relaxed-Eye Stereo", "releye",
		gnome_graphics_view::popup_ProjRelaxedEye, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::projection_submenu[] =
{
        GNOMEUIINFO_RADIOLIST(projection_radio),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::render_submenu[] =
{
	GNOMEUIINFO_SUBTREE("_Views", views_submenu),
	GNOMEUIINFO_SUBTREE("_Lights", lights_submenu),
	GNOMEUIINFO_SUBTREE("_Rendering Mode", rendermode_submenu),
	GNOMEUIINFO_SUBTREE("_Projection", projection_submenu),
	
	GNOMEUIINFO_TOGGLEITEM("Quick Update Mode", "quick update...",
		gnome_graphics_view::popup_RenderQuickUpdate, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::objects_submenu[] =
{
	GNOMEUIINFO_ITEM("Ribbon", "...",
		popup_ObjRibbon, NULL),
		
	GNOMEUIINFO_ITEM("ESP-plane", "...",
		popup_ObjEPlane, NULL),
		
	GNOMEUIINFO_ITEM("volume-rendered ESP", "...",
		popup_ObjEVolume, NULL),
		
	GNOMEUIINFO_ITEM("ESP-surface", "...",
		popup_ObjESurface, NULL),
		
	GNOMEUIINFO_ITEM("ESP-colored vdW-surface", "...",
		popup_ObjVDWSurface, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Delete Current Object", "delete",
		gnome_graphics_view::popup_ObjectsDeleteCurrent, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::compute_submenu[] =
{
	GNOMEUIINFO_ITEM("Energy", "...",
		popup_CompEnergy, NULL),
		
	GNOMEUIINFO_ITEM("Geometry Optimization...", "...",
		popup_CompGeomOpt, NULL),
		
	GNOMEUIINFO_ITEM("Molecular Dynamics...", "...",
		popup_CompMolDyn, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::popupmenu_info[] =
{
	GNOMEUIINFO_SUBTREE("_File", file_submenu),
	GNOMEUIINFO_SUBTREE("_Select", select_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Render", render_submenu),
	GNOMEUIINFO_SUBTREE("_Objects", objects_submenu),

	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Compute", compute_submenu),
	
	GNOMEUIINFO_ITEM("MD Trajectory Viewer...", "...",
		popup_TrajView, NULL),

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_ITEM("Enter a Command...", "Type in a command string and process it.",
		popup_EnterCommand, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::popupmenu_dummy[] =
{
        GNOMEUIINFO_SUBTREE("Ghemical", popupmenu_info),
        GNOMEUIINFO_END
};

/*################################################################################################*/

mm2_geomopt_param * gnome_mm2_docv::goparam = NULL;
mm2_moldyn_param * gnome_mm2_docv::mdparam = NULL;

gnome_mm2_docv::gnome_mm2_docv(ostream * p1, gnome_class_factory & p2, mm2_eng_param * p3) :
	gnome_docv(p1, p2), mm2_docv(p1, p2, p3), docview(p1, p2), model_simple(p1, p2)
{
	popupmenu = gnome_popup_menu_new(popupmenu_info);
}

gnome_mm2_docv::~gnome_mm2_docv(void)
{
}

void gnome_mm2_docv::popup_FileOpen(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	docv->err->Message("Sorry, this feature is not yet implemented.\nPlease use File/New + File/ExtraTools/ImportPDB instead.");
}

void gnome_mm2_docv::popup_FileSaveAs(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv) new mm2_file_save_dialog(docv);
}

void gnome_mm2_docv::popup_FileExtra1(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		new mm2_importpdb_dialog(docv);
	}
}

void gnome_mm2_docv::popup_RModeWireFrame(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_WIREFRAME; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeBallAndStick(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_BALL_AND_STICK; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeVanDerWaals(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_VAN_DER_WAALS; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeAccessible(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_ACCESSIBLE; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeCylinders(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_CYLINDERS; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeNothing(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_NOTHING; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_LModeNothing(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_NOTHING; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_LModeResidue(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_RESIDUE; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_LModeDEBUG(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_CHARGE; gv->docv->UpdateAllGraphicsViews();			// DEBUG!!!
}

void gnome_mm2_docv::popup_CModeState(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->colormode = & mm2_docv::cm_state; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_CModeResidue(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->colormode = & mm2_docv::cm_residue; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_CModeSASA(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->colormode = & mm2_docv::cm_sasa; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_ObjRibbon(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		for (i32s n1 = 0;n1 < (i32s) docv->chn_vector.size();n1++)
		{
			smart_object * NewObject;
			NewObject = new mm2_ribbon(docv, gv->colormode, n1, 4);		// min. order is 2!!!
			docv->AddObject(NewObject);
		}
		
		docv->UpdateAllGraphicsViews();
	}
}

// planes/surfaces/etc... are done here, in a simple and straightforward way.
// just equivalent stuff is repeated at TARGET2. how to improve this???

// an advanced dialog box would be needed here, to replace the text stuff.
// the dialog should be flexible enough, so it could be used in all models, not just here...

// does it make any sense to write DoPlane, DoSurface, etc???

void gnome_mm2_docv::popup_ObjEPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		static const char command[] = "add plane esp rb1 14.0 2.5 50 1 0.75";
		new command_dialog(docv, gv, command);
	}
}

void gnome_mm2_docv::popup_ObjEVolume(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		static const char command[] = "add volrend esp rb2 14.0 2.5 25 0.50";
		new command_dialog(docv, gv, command);
	}
}

void gnome_mm2_docv::popup_ObjESurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		static const char command[] = "add surf2 esp unity red blue +14.0 -14.0 1.0 5.0 50 0 0 0.50";
		new command_dialog(docv, gv, command);
	}
}

void gnome_mm2_docv::popup_ObjVDWSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		static const char command[] = "add surf1 vdws esp rb1 1.0 14.0 5.0 50 1 1 0.65";
		new command_dialog(docv, gv, command);
	}
}

void gnome_mm2_docv::popup_CompEnergy(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv) docv->DoEnergy();
}

void gnome_mm2_docv::popup_CompGeomOpt(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		mm2_geomopt_param param;
		param.treshold_nsteps = 500;
		param.treshold_grad = 0.0;	// not yet used...
		param.treshold_delta_e = 0.0;	// not yet used...
		
		docv->DoGeomOpt(param);
	}
}

void gnome_mm2_docv::popup_CompMolDyn(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		mm2_moldyn_param param;
		param.nsteps = 10000;
		param.temperature = 300.0;
		param.timestep = 5.0;
		
		docv->DoMolDyn(param);
	}
}

void gnome_mm2_docv::popup_TrajView(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (!docv->GetTrajectoryFile())
	{
		if (docv) new mm2_trajfile_dialog(docv);
	}
	else docv->err->ErrorMessage("Trajectory already open?!?!?!");
}

void gnome_mm2_docv::popup_EnterCommand(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		new command_dialog(docv, gv, NULL);
	}
}

/*##############################################*/
/*##############################################*/

void gnome_mm2_docv::GeomOptGetParam(mm2_geomopt_param & param)
{
	glade_modal_dialog_owner = this;	// requires modal dialogs!!!
	
	// here we just set "param" to a static variable,
	// where it's then available in glade code...
	
	goparam = & param;
	
	new geomopt_dialog();	// the object will call delete itself...
	//GtkWidget * dialog = create_a1_dialog_geomopt();	// obsolete
	//gnome_dialog_run_and_close(GNOME_DIALOG(dialog));	// obsolete
	
	goparam = NULL;
}

#define START 10000	// see mm1docv.cpp!!!!!!!!

void gnome_mm2_docv::MolDynGetParam(mm2_moldyn_param & param)
{
	glade_modal_dialog_owner = this;	// requires modal dialogs!!!
	
	// here we just set "param" to a static variable,
	// where it's then available in glade code...
	
	mdparam = & param;
	
	new moldyn_dialog();	// the object will call delete itself...
	//GtkWidget * dialog = create_a2_dialog_moldyn();	// obsolete
	//gnome_dialog_run_and_close(GNOME_DIALOG(dialog));	// obsolete
	
	mdparam = NULL;
}

/*################################################################################################*/

// eof
