// T2MAIN.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t2main.h"
#include "notice.h"

#include <gsl/gsl_ieee_utils.h>

/*################################################################################################*/

#define MODEL_QM1	0x0101
#define MODEL_QM2	0x0102

#define MODEL_MM1	0x0201
#define MODEL_MM2	0x0202
#define MODEL_MM3	0x0203

int main(int argc, char ** argv)
{
	print_full_copyright_notice(cout);
	
	gsl_ieee_env_setup();	// setup an IEEE mode that allows gdb trap SIGFPE from failed floating point operations...
	
	// add "double-buffer"-flag to the command line!??!?!?!
	// add "stereo"-flag to the command line (once it works in OGL/Mesa)!??!?!?!
	
	i32s mtype = MODEL_MM1;
	for (i32s n1 = 1;n1 < argc;n1++)
	{
		if (!strcmp(argv[n1], "-h") || !strcmp(argv[n1], "--help"))
		{
			cout << "command-line options:" << endl;
			cout << "---------------------" << endl;
			cout << endl;
			cout << "-m, --model : select the model" << endl;
			cout << "   q1 -> QM, molecular calculations" << endl;
			cout << "   q2 -> QM, atomic calculations (just a basis set viewer)" << endl;
			cout << "   m1 -> MM, \"all atoms\"-model (this is the default)" << endl;
			cout << "   m2 -> MM, simplified protein model" << endl;
			cout << "   m3 -> MM, ?????" << endl;
			cout << endl;
			
			cout << "command-line help ???" << endl;
			return 0;
		}
		
		if ((!strcmp(argv[n1], "-m") || !strcmp(argv[n1], "--model")) && (++n1 < argc))
		{
			if (!strcmp(argv[n1], "q1")) mtype = MODEL_QM1;
			if (!strcmp(argv[n1], "q2")) mtype = MODEL_QM2;
			if (!strcmp(argv[n1], "m1")) mtype = MODEL_MM1;
			if (!strcmp(argv[n1], "m2")) mtype = MODEL_MM2;
			if (!strcmp(argv[n1], "m3")) mtype = MODEL_MM3;
		}
	}
	
	glutInit(& argc, argv);
	glutInitWindowPosition(10, 10);
	glutInitWindowSize(400, 400);
	
	glutInitDisplayMode(GLUT_RGBA | GLUT_DEPTH | GLUT_ACCUM | GLUT_DOUBLE);
	
	docview * docv = NULL;
	
	switch (mtype)
	{
		case MODEL_QM1:
		docv = new glut_qm1_docv(& cout, * glut_class_factory::GetInstance());
		docv->AddGraphicsView();
		break;
		
		case MODEL_QM2:
		docv = new glut_qm2_docv(& cout, * glut_class_factory::GetInstance());
		docv->AddGraphicsView();
		break;
		
		case MODEL_MM1:
		docv = new glut_mm1_docv(& cout, * glut_class_factory::GetInstance());
		docv->AddGraphicsView();
		break;
		
		case MODEL_MM2:
		docv = new glut_mm2_docv(& cout, * glut_class_factory::GetInstance(), NULL);
		docv->AddGraphicsView();
		break;
		
		case MODEL_MM3:
		docv = new glut_mm3_docv(& cout, * glut_class_factory::GetInstance());
		docv->AddGraphicsView();
		break;
		
		default:
		cout << "something went wrong..." << endl;
		return 0;
	}
	
	cout << "model type is " << docv->GetType() << endl;
	cout << "press 'h' for help..." << endl;
	
	glutMainLoop();		// there is no return from this loop...
}

/*################################################################################################*/

// eof
