// MM2UTIL.H : various utility classes for simplified protein models.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM2UTIL_H
#define MM2UTIL_H

class mm2_chn;
class mm2_res;
class mm2_atm;

class mm2_dsb;	// struct???

/*################################################################################################*/

class mm2_mdl;		// mm2mdl.h
struct mm2_eng_param;	// mm2mdl.h

#include "define.h"
#include "typedef.h"

#include <vector>
using namespace std;

/*################################################################################################*/

class mm2_chn
{
//	protected:
	public:		// heavily used...
	
	char * description;
	vector<mm2_res> res_vector;
	
	// the original PDB-metadata (if any) is stored here:
	// the original PDB-metadata (if any) is stored here:
	// the original PDB-metadata (if any) is stored here:
	
	char pdb_chn_id;
	char * pdb_seqres;
	
	vector<i32s> pdb_missing_residues;
	
	public:
	
	mm2_chn(void);
	mm2_chn(const char *);
	mm2_chn(const mm2_chn &);
	~mm2_chn(void);
	
	void SetDescription(const char *);
};

/*################################################################################################*/

#define STATE_HELIX	0
#define STATE_STRAND	1
#define STATE_LOOP	2

class mm2_res
{
//	protected:
	public:		// heavily used...
	
	char symbol;
	i32u natm;
	
	i32s state;
	
	bool sel;
	
	vector<a3_fGL> crd_vector[3];
	vector<fGL> peptide_vector;
	
	f64 mass[3];
	f64 vdwr[3];
	
	f64 charge[3];
	f64 sasa[3];
	
	f64 tmp_sasa[3];	// is ignored in copy ctor!!!
	f64 tmp_charge[3];	// is ignored in copy ctor!!!
	f64 tmp_newpKa[3];	// is ignored in copy ctor!!!
	f64 * tmp_smooth[3];	// is ignored in copy ctor!!!
f64 tmp_z1[3];	// is ignored in copy ctor!!!
f64 tmp_z2[3];	// is ignored in copy ctor!!!
	
	f64 label[3];	// debug!!!
	
	public:
	
	mm2_res(void);
	mm2_res(char, i32u, mm2_eng_param *);
	mm2_res(const mm2_res &);
	~mm2_res(void);
};

/*################################################################################################*/

class mm2_atm
{
	private:
	
	i32u data;
	
	public:
	
	mm2_atm(void);
	mm2_atm(i32u, i32u, i32u);
	~mm2_atm(void);
	
	i32u operator[](i32s) const;
	bool operator==(const mm2_atm &) const;
};

/*################################################################################################*/

class mm2_dsb		// disulphide bridge
{
//	protected:
	public:		// heavily used...
	
	i32s chn[2];
	i32s res[2];
	
	public:
	
	mm2_dsb(void) { }
	~mm2_dsb(void) { }
};

/*################################################################################################*/

//struct mm2_debug	// debug!!!
//{
//	fGL crd[3];
//	fGL color[3];
//};

/*################################################################################################*/

#endif	// MM2UTIL_H

// eof
