// MM1ENG9.H : slightly modified engine class for parameter fitting.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1ENG9_H
#define MM1ENG9_H

struct mm1_prmfit_bt1;		// bond stretching
struct mm1_prmfit_bt2;		// angle bending
struct mm1_prmfit_bt3;		// torsion
struct mm1_prmfit_bt4;		// out of plane

struct mm1_prmfit_nbt1;		// nonbonded

class mm1_eng_prmfit;

/*################################################################################################*/

#include "mm1eng.h"

#include "mm1tab9.h"

#include <vector>
using namespace std;

/*################################################################################################*/

struct mm1_prmfit_bt1
{
	i32s atmi[2];
	
	f64 opt;
	f64 fc;
	
	i32s get_atmi(i32s index, bool dir)
	{
		return atmi[dir ? index : !index];
	}
	
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...
	
	i32s bt;
	i32s qi;
	f64 x;
};

struct mm1_prmfit_bt2
{
	i32s atmi[3];
	
	i32s index1[2]; bool dir1[2];
	
	f64 opt;
	f64 fc;
	
	i32s get_index(i32s index, bool dir)
	{
		return index1[dir ? index : !index];
	}
	
	bool get_dir(i32s index, bool dir)
	{
		return dir1[dir ? index : !index];
	}
	
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...

	i32s bt[2];
	
	f64 x;
};

struct mm1_prmfit_bt3
{
	i32s atmi[4];
	
	i32s index2[2];
	i32s index1[4]; bool dir1[4];
	
	f64 k[3];
	f64 t[3];
	
	bool constraint;
	
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...

	i32s bt[3];
	
	f64 x;
};

struct mm1_prmfit_bt4
{
	i32s atmi[4];
	
	i32s index2; bool dir2;
	i32s index1[3]; bool dir1[3];
	
	f64 opt;
	f64 fc;
	
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...
	
	i32s bt[3];
	
	f64 x;
};

struct mm1_prmfit_nbt1
{
	i32s atmi[2];
	
	f64 k1;
	f64 k2;
	
	f64 qq;
	
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...
	// these records contain information that is used in parameter derivation process...
};

/*################################################################################################*/

/// This is a slightly modified and patched eng-class for parameter fitting.

class mm1_eng_prmfit : public mm1_eng
{
	protected:
	
	mm1_bt1_data * bt1data;
	mm1_bt2_data * bt2data;
	
	vector<mm1_prmfit_bt1> bt1_vector;
	vector<mm1_prmfit_bt2> bt2_vector;
	vector<mm1_prmfit_bt3> bt3_vector;
	vector<mm1_prmfit_bt4> bt4_vector;
	
	vector<mm1_prmfit_nbt1> nbt1_vector;
	
	friend class prmfit_tables;
	friend class prmfit_cg_optim;
	
	public:
	
	mm1_eng_prmfit(mm1_mdl &, prmfit_tables &);
	virtual ~mm1_eng_prmfit(void);
	
	i32s FindTorsion(mm1_atom *, mm1_atom *, mm1_atom *, mm1_atom *);	// virtual
	bool SetTorsionConstraint(i32s, f64, f64, bool);			// virtual
	
	protected:
	
	void ComputeBT1(i32s);		// virtual
	void ComputeBT2(i32s);		// virtual
	void ComputeBT3(i32s);		// virtual
	void ComputeBT4(i32s);		// virtual
	
	void ComputeNBT1(i32s);		// virtual
};

/*################################################################################################*/

#endif	// MM1ENG9_H

// eof
