with Types; use Types;

package Str_Table is
   --  Create a new entry in the string table and returns a number to it.
   function Start return String_Id;
   pragma Inline (Start);

   --  Add a new character in the current entry.
   procedure Append (C : Character);
   pragma Inline (Append);

   --  Finish the current entry.
   procedure Finish;
   pragma Inline (Finish);

   --  Get a fat access to the string ID.
   function Get_String_Fat_Acc (Id : String_Id) return String_Fat_Acc;
   pragma Inline (Get_String_Fat_Acc);

   --  Get ID as a string.
   --  This function is slow, to be used only for debugging.
   function Image (Id : String_Id) return String;
end Str_Table;

