from main import USERHOME
from datatypes import *
import Unit
import pwstore


#
# This class contains functions to convert strings to types and vice-versa.
#
class TypeConverter(dict):

    def __init__(self):

        dict.__init__(self)


    #
    # Adds a new type
    #
    add_type = dict.__setitem__


    def str2type(self, key, v):

        dtype = self.get(key, TYPE_STRING)
        v = str(v)
        return self.__convert(dtype, v)
        

    def __convert(self, dtype, v):

        if (dtype == TYPE_STRING): return v

        elif (dtype == TYPE_SECRET_STRING):
            return pwstore.retrieve(USERHOME, v)

        elif (dtype == TYPE_BOOL):
            return (v in ["True", "true", "1"])

        elif (dtype == TYPE_INT): return int(v)

        elif (dtype == TYPE_FLOAT): return float(v)

        elif (dtype == TYPE_LIST):
            v = v.replace("\\,", "@@COMMA@@")
            parts = v.split(",")
            return [p.strip().replace("@@COMMA@@", ",") for p in parts]

        elif (dtype == TYPE_UNIT):
            if (v[-1] == "%"):
                value = float(v[:-1])
                unit = Unit.UNIT_PERCENT
            elif (v[-2:] == "cm"):
                value = float(v[:-2])
                unit = Unit.UNIT_CM
            elif (v[-2:] == "in"):
                value = float(v[:-2])
                unit = Unit.UNIT_IN
            elif (v[-2:] == "pt"):
                value = float(v[:-2])
                unit = Unit.UNIT_PT
            else:
                value = int(float(v))
                unit = Unit.UNIT_PX
            return Unit.Unit(value, unit)

        elif (dtype == TYPE_UNIT_LIST):
            parts = v.split(",")
            return [ self.__convert(TYPE_UNIT, unit.strip()) for unit in parts ]
            
        else:
            return v


    #
    # This method is only used by Sensor and is thus deprecated.
    #
    def type2str(self, key, v):

        dtype = self.get(key, TYPE_STRING)

        if (dtype == TYPE_LIST and isinstance(v, list)): return ",".join(v)

        elif (dtype == TYPE_SECRET_STRING):
            return pwstore.store(USERHOME, v)

        elif (dtype == TYPE_BOOL): return v and "true" or "false"

        elif (dtype == TYPE_UNIT):
            value, unit = v
            if (unit != UNIT_PX): return str(value) + unit
            else: return str(value)

        else: return str(v)
