from TargetCanvas import TargetCanvas
from utils.datatypes import *


#
# Class for plotting graphs.
#
class TargetPlotter(TargetCanvas):

    def __init__(self, parent):

        # history of plot values
        self.__history = []

        # colors
        self.__bgcolor = ""
        self.__color = "navy"

        TargetCanvas.__init__(self, parent)

        self._register_property("value", TYPE_FLOAT,
                                self._setp_value, self._getp)
        self._register_property("bg-color", TYPE_STRING,
                                self._setp_bgcolor, self._getp)
        self._register_property("color", TYPE_STRING,
                                self._setp_color, self._getp)
        self._register_property("size", TYPE_INT,
                                self._setp, self._getp)
        self._setp("size", 50)
        self._register_property("scala", TYPE_INT,
                                self._setp, self._getp)
        self._setp("scala", 0)
        self._register_property("scala-color", TYPE_STRING,
                                self._setp, self._getp)
        self._setp("scala-color", "black")
        self._register_property("scala-font", TYPE_STRING,
                                self._setp, self._getp)
        self._setp("scala-font", "Sans")




    #
    # Plots the values from the history.
    #
    def __plot(self):

        bg, fg = self.__bgcolor, self.__color
        size = self.get_prop("size")

        x = 0.0
        delta_x = 100.0 / (size - 1)

        max_value = max(100, max(self.__history))
        scale = 100.0 / max_value

        x, y = x, self.__history[0]
        if (bg):
            body = "<rect x=\"0\" y=\"0\" width=\"100\" height=\"100\" " \
                   "style=\"stroke:%s;fill:%s\"/>" % (bg, bg)
        else:
            body = ""

        body += "<path d=\"M%f %f " % (x, 100 - y * scale)
        x += delta_x

        for y in self.__history[1:]:
            y = 100 - y * scale
            body += "L%(x)f %(y)f " % vars()
            x += delta_x
        body += "\" style=\"stroke:%s;opacity:%s%%;fill:none\"/>" % \
                                                        self.__parse_color(fg)

        # draw scala
        scala = self.get_prop("scala")
        if (scala):
            scala_color = self.get_prop("scala-color")
            scala_font = self.get_prop("scala-font")
            for i in range(0, max_value + 1, scala):
                body += "<text x=\"0\" y=\"%d\" font-family=\"%s\" " \
                        "font-size=\"%d\" fill=\"%s\">%d</text>" \
                        % (max_value - i, scala_font, 5, scala_color, i)

        gfx = "<svg>" + body + "</svg>"
        self.set_prop("graphics", gfx)



    def __parse_color(self, value):

        if ("#" in value and len(value) == 9):
            opacity = float(int(value[7:], 16) / 255.0) * 100
            return (value[:7], opacity)
        else:
            return (value, 100)



    def _setp_value(self, key, value):

        self.__history.append(value)
        self.__plot()
        if (len(self.__history) > self.get_prop("size")):
            self.__history.pop(0)
        self._setp(key, value)



    def _setp_bgcolor(self, key, value):

        self.__bgcolor = value
        self._setp(key, value)


    def _setp_color(self, key, value):

        self.__color = value
        self._setp(key, value)
