/*
 * gAcc_edittrs.c
 * Thomas Nemeth, le 14.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "defines.h"
#include "structs.h" 
#include "gAcc_edittrs.h"
#include "acclists.h"
#include "operations.h"
#include "tiers.h"
#include "gAcc_opelist.h"
#include "gAcc_trslist.h"


/*** Create the "Edit trsegory" dialog box ****************************/

void edittrs_ok_cb (GtkWidget *widget, void *data) {
    MY_LIST   *list         = (MY_LIST *)   data;
    GtkWidget *window       = (GtkWidget *) my_list_get_element (list, 0);
    GtkWidget *clist        = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *edittrs_name = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *edittrs_num  = (GtkWidget *) my_list_get_element (list, 3);
    TIERS     *tiers        = (TIERS     *) my_list_get_element (list, 4);
    OPERATION *operation    = (OPERATION *) my_list_get_element (list, 5);
    int        new          = VRAI;
    char      *name;
    int        number;

    name        = gtk_entry_get_text (GTK_ENTRY (edittrs_name) );
    number      = atoi (gtk_entry_get_text (GTK_ENTRY (edittrs_num) ) );

    if (tiers == NULL) {
        tiers = tiers_new ();
    } else {
        /* remove_tiers (tiers); */
        new = FAUX;
    }

    trs_set_name (tiers, name);
    trs_set_num  (tiers, number);

    if (new == VRAI) add_tiers (tiers);

    if (operation != NULL) {
        ope_set_tiers (operation, number);
        if (clist != NULL) set_ope_list (clist);
    } else if (clist != NULL) {
        gtk_clist_clear (GTK_CLIST (clist) );
        set_trs_list (clist);
        gtk_clist_unselect_all (GTK_CLIST (clist) );
    }
    gtk_widget_destroy (window);
    my_list_free (list);
}

void edittrs_cancel_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

GtkWidget *create_edittrs_dialog (MY_LIST *inlist) {
    GtkWidget *Edittrs_Dialog;
    GtkWidget *bouton;
    GtkWidget *label;
    GtkWidget *hbox;
    GtkWidget *clist     =  (GtkWidget *) my_list_get_element (inlist, 0);
    TIERS     *tiers     =  (TIERS     *) my_list_get_element (inlist, 1);
    char      *name      =  (char      *) my_list_get_element (inlist, 2);
    char      *num       =  (char      *) my_list_get_element (inlist, 3);
    OPERATION *operation =  (OPERATION *) my_list_get_element (inlist, 5);
    char      *number;
    GtkWidget *edittrs_name;
    GtkWidget *edittrs_num;
    MY_LIST   *list = NULL;

    Edittrs_Dialog = gtk_dialog_new ();
    list = my_list_add (list, Edittrs_Dialog); /* 0 */
    list = my_list_add (list, clist);          /* 1 */
    gtk_signal_connect (GTK_OBJECT (Edittrs_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (Edittrs_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label ( _("OK") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (edittrs_ok_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Edittrs_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_grab_default (GTK_WIDGET (bouton) );
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Cancel") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (edittrs_cancel_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Edittrs_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    /* Tiers Name */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("3rd party name : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    edittrs_name = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), edittrs_name, TRUE, TRUE, 6);
    gtk_widget_show (edittrs_name);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Edittrs_Dialog)->vbox), hbox,
                        TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    /* Tiers Number */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("3rd party number : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    edittrs_num = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), edittrs_num, TRUE, TRUE, 6);
    gtk_widget_show (edittrs_num);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Edittrs_Dialog)->vbox), hbox,
                        TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    if (tiers != NULL) {
        gtk_entry_set_text (GTK_ENTRY (edittrs_name),
                            tiers->name != NULL ? tiers->name : "");
        MY_ALLOC (number, 12, char);
        sprintf (number, "%d", tiers->num);
        gtk_entry_set_text (GTK_ENTRY (edittrs_num), number);
        free (number);
    } else if ( (tiers == NULL) && (name == NULL) && (num == NULL) ) {
        gtk_entry_set_text (GTK_ENTRY (edittrs_name), "");
        MY_ALLOC (number, 12, char);
        sprintf (number, "%d", get_tiers_next_num () );
        gtk_entry_set_text (GTK_ENTRY (edittrs_num), number);
        free (number);
    } else {
        gtk_entry_set_text (GTK_ENTRY (edittrs_name), name != NULL ? name : "");
        gtk_entry_set_text (GTK_ENTRY (edittrs_num), num);
        free (num);
    }

    gtk_widget_grab_focus (GTK_WIDGET (edittrs_name) );
    gtk_widget_draw_focus (GTK_WIDGET (edittrs_name) );

    list = my_list_add (list, edittrs_name);                     /* 2 */
    list = my_list_add (list, edittrs_num);                      /* 3 */
    list = my_list_add (list, tiers);                            /* 4 */
    list = my_list_add (list, operation);                        /* 5 */

    my_list_free (inlist);

    #ifdef DEBUG_GACC
        printf ("Affichage de la fentre d'informations du tiers\n");
    #endif

    return Edittrs_Dialog;
}
