#!/usr/bin/env python

import types

class Dumper:

    indent = "\t"

    def __init__(self):

        # We're going to keep references to objects that we've already
        # seen in a list
        self.seen = []

        return

    def dump(self, obj):
        self.dump_rec(obj, 0)
        
    def dump_rec(self, obj, level):
        
        attributes = dir(obj)
        attributes.sort()

        self.seen.append(obj)
        
        for attribute in attributes:
            
            value = getattr(obj, attribute)
            print Dumper.indent * level, attribute, ':', value

            if (type(value) == types.InstanceType and
                not value in self.seen):
                self.dump_rec(value, level+1)

        return
