#ifndef FILES_H
#define FILES_H

#ifndef SERVER_H
#include "server.h"
#endif

#ifndef FILELIST_H
#include "filelist.h"
#endif

#ifndef GUIUTILS_H
#include "guiutils.h"
#endif

void check_files(Connection *c);
void show_files(Connection *c);
char *files_get_path(FileList *fl);
void fileentry_get_icon(FileEntry *fe,GdkPixmap **icon,GdkPixmap **mask);
void file_format_size(char *buf,int size,gboolean with_bytes);
char *files_convert_name_to_local(char *filename);

typedef struct {
  Connection *c;
  NotebookPage *notebook_page;
  Task *task;
  GHashTable *remote_cache;
  FileList *remote_files;
  FileList *local_files;

  unsigned int recursive_transfer:1;
  unsigned int recursive_is_download:1;
  GList *recursive_folders_list;
  char *recursive_orig_local_path;
  char *recursive_orig_remote_path;
} FileData;

typedef struct {
  char *local_path;
  char *remote_path;
  char *folder_name;
  FileData *fd;
} TransferFolder;

#endif
