/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 22:11:23 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_hc2hc -compact -variables 4 -sign 1 -n 5 -dif -name hb_5 -include hb.h */

/*
 * This function contains 40 FP additions, 28 FP multiplications,
 * (or, 26 additions, 14 multiplications, 14 fused multiply/add),
 * 27 stack variables, and 20 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.9 2003/04/17 19:25:50 athena Exp $
 */

#include "hb.h"

static const R *hb_5(R *rio, R *iio, const R *W, stride ios, int m, int dist)
{
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     int i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 8) {
	  E T1, Tj, TG, Ts, T8, Ti, T9, Tn, TD, Tu, Tg, Tt;
	  {
	       E T7, Tr, T4, Tq;
	       T1 = rio[0];
	       {
		    E T5, T6, T2, T3;
		    T5 = rio[WS(ios, 2)];
		    T6 = iio[-WS(ios, 3)];
		    T7 = T5 + T6;
		    Tr = T5 - T6;
		    T2 = rio[WS(ios, 1)];
		    T3 = iio[-WS(ios, 4)];
		    T4 = T2 + T3;
		    Tq = T2 - T3;
	       }
	       Tj = KP559016994 * (T4 - T7);
	       TG = FMA(KP951056516, Tq, KP587785252 * Tr);
	       Ts = FNMS(KP951056516, Tr, KP587785252 * Tq);
	       T8 = T4 + T7;
	       Ti = FNMS(KP250000000, T8, T1);
	  }
	  {
	       E Tf, Tm, Tc, Tl;
	       T9 = iio[0];
	       {
		    E Td, Te, Ta, Tb;
		    Td = iio[-WS(ios, 2)];
		    Te = rio[WS(ios, 3)];
		    Tf = Td - Te;
		    Tm = Td + Te;
		    Ta = iio[-WS(ios, 1)];
		    Tb = rio[WS(ios, 4)];
		    Tc = Ta - Tb;
		    Tl = Ta + Tb;
	       }
	       Tn = FNMS(KP951056516, Tm, KP587785252 * Tl);
	       TD = FMA(KP951056516, Tl, KP587785252 * Tm);
	       Tu = KP559016994 * (Tc - Tf);
	       Tg = Tc + Tf;
	       Tt = FNMS(KP250000000, Tg, T9);
	  }
	  rio[0] = T1 + T8;
	  iio[-WS(ios, 4)] = T9 + Tg;
	  {
	       E TE, TM, TI, TK, TC, TH;
	       TC = Tj + Ti;
	       TE = TC - TD;
	       TM = TC + TD;
	       TH = Tu + Tt;
	       TI = TG + TH;
	       TK = TH - TG;
	       {
		    E TB, TF, TJ, TL;
		    TB = W[0];
		    TF = W[1];
		    rio[WS(ios, 1)] = FNMS(TF, TI, TB * TE);
		    iio[-WS(ios, 3)] = FMA(TB, TI, TF * TE);
		    TJ = W[6];
		    TL = W[7];
		    iio[0] = FMA(TJ, TK, TL * TM);
		    rio[WS(ios, 4)] = FNMS(TL, TK, TJ * TM);
	       }
	  }
	  {
	       E To, TA, Tw, Ty, Tk, Tv;
	       Tk = Ti - Tj;
	       To = Tk - Tn;
	       TA = Tk + Tn;
	       Tv = Tt - Tu;
	       Tw = Ts + Tv;
	       Ty = Tv - Ts;
	       {
		    E Th, Tp, Tx, Tz;
		    Th = W[2];
		    Tp = W[3];
		    rio[WS(ios, 2)] = FNMS(Tp, Tw, Th * To);
		    iio[-WS(ios, 2)] = FMA(Th, Tw, Tp * To);
		    Tx = W[4];
		    Tz = W[5];
		    iio[-WS(ios, 1)] = FMA(Tx, Ty, Tz * TA);
		    rio[WS(ios, 3)] = FNMS(Tz, Ty, Tx * TA);
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 5},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 5, "hb_5", twinstr, {26, 14, 14, 0}, &GENUS, 0, 0, 0 };

void X(codelet_hb_5) (planner *p) {
     X(khc2hc_dif_register) (p, hb_5, &desc);
}
