#! /bin/bash
#
# Copyright (C) 2004 Tomas Golembiovsky
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of the libEtPan! project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# Requires: grep, sed, vim
#
# $Id: install.sh,v 1.1 2005/02/09 01:07:06 nyoxi Exp $
#

AUDEF="\" Syntax for etpan config files
au BufNewFile,BufRead ~/.libetpan/config/{global,abook-config,account,color,discovery,mime-config,sender,smime-config,storage,vfolder}		setf etpancfg "

function instlocal
{
	viminstall "$HOME/.vim"
	return $?
}

function instglobal
{
	# Check if variable VIM is set
	if [ -z $VIM ] ; then
		# Get default path from vim
		VIM=`vim --version | grep 'fall-back for $VIM' |
			 sed 's/^[^"]*"\([^"]*\).*$/\1/'`
	fi
	if [ -z $VIM ] ; then
		echo "Unable to find out the vim directory! Specify it manualy."
		read VIM
	fi
	#valid="n"
	#while [ "$valid" != "Y" -a "$valid" != "y" ] ; do
	#	echo -n "Is the path '$VIM' valid? [y/n]: "
	#	read valid
	#	if [ "$valid" == "N" -o "$valid" == "n" ] ; then
	#		echo "Specify the path"
	#		read VIM
	#	fi
	#done
	viminstall "$VIM/vimfiles"
}

# Usage: viminstall <path>
function viminstall
{
	if [ $# -ne 1 ] ; then
		echo "Usage: $0 <path>"
		return 1
	fi

	# Create the syntax directroy if it doesn't exist
	if [ ! -d "$1/syntax" ] ; then
		mkdir -p -v "$1/syntax"
		if [ $? -ne 0 ] ; then return 1 ; fi
	fi

	# Copy the syntax file
	cp -v etpancfg.vim "$1/syntax"
	if [ $? -ne 0 ] ; then return 1 ; fi

	echo "Modyfying filetype.vim"
	add=1
	# Modify the filetype.vim
	if [ -f "$1/filetype.vim" ] ; then
		grep "augroup filetypedetect" "$1/filetype.vim" >& /dev/null
		# TODO : check if there isn't our line already, we'll need to replace it
		if [ $? -eq 0 ] ; then
			# edit the file
			(cat <<-EOT
				e $1/filetype.vim
				/^augroup filetypedetect
				+1insert
				$AUDEF
				.
				wq
			EOT
			) | vim -e -s
			if [ $? -ne 0 ] ; then return 1 ; fi
			add=0
		fi
	fi

	if [ $add -eq 1 ] ; then
		# The file doesn't exist or the section doesn't exist, so we'll
		# create it
		(cat <<-EOT
			augroup filetypedetect
			$AUDEF
			augroup END
			EOT
		) >> "$1/filetype.vim"
		if [ $? -ne 0 ] ; then return 1 ; fi
	fi
	
	# Mission accomplished successfully :)
	return 0
}


cat <<EOT
You are going to install VIM syntax highlighting scheme for etpan
configuration files.
Select the type of installation:
1) System-wide installation (for all users) - note that you must have
   write access to VIM runtime directory
2) Local instalation (only for current user)

Which one do you choose? [1/2]:
EOT
read type

# Check if selection is valid
if [ "$type" != "1" -a "$type" != "2" ] ; then
	echo "Invalid selection. Exiting!"
	exit 1
fi

# Perform the installation
if [ "$type" -eq "1" ] ; then
	echo "Performing system-wide installation"
	instglobal
	if [ $? -ne 0 ] ; then
		echo "Unable to perform system-wide installation!"
		while [ "$choice" != "Y" -a "$choice" != "y" -a \
				"$choice" != "N" -a "$choice" != "n" ] ; do
			echo "Try to install localy? [y/n]: "
			read choice
		done
		if [ "$choice" == "Y" -o "$choice" == "y" ] ; then
			# Change the type and continue
			type=2
		fi
	fi
fi

if [ "$type" -eq "2" ] ; then
	echo "Performing local installation"
	instlocal
	if [ $? -ne 0 ] ; then
		echo "Unable to perform local installation!"
	fi
fi
