" Vim syntax file
" Language:     Syntax file for etpan configuration files
" Maintainer:   Tomas Golembiovsky <nyoxi@seznam.cz>
" Last Change:  2005-02-08  15:30
" Version:      1
"
" Copyright (C) 2004 Tomas Golembiovsky
" All rights reserved.
"
" Redistribution and use in source and binary forms, with or without
" modification, are permitted provided that the following conditions
" are met:
" 1. Redistributions of source code must retain the above copyright
"    notice, this list of conditions and the following disclaimer.
" 2. Redistributions in binary form must reproduce the above copyright
"    notice, this list of conditions and the following disclaimer in the
"    documentation and/or other materials provided with the distribution.
" 3. Neither the name of the libEtPan! project nor the names of its
"    contributors may be used to endorse or promote products derived
"    from this software without specific prior written permission.
"
" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
" SUCH DAMAGE.
"
" $Id: etpancfg.vim,v 1.1 2005/02/09 01:07:06 nyoxi Exp $
"
" 2005-02-02
"   So it begun ...
"

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

syn case match
syn match etpanComment /^\s*#.*$/
syn match etpanToken /^[a-z-]\+\s*=/ contains=etpanTokenId,etpanTokensAll
"syn match etpanValue /=\@<=.*$/hs=s+1

if version >= 600
  setlocal iskeyword+=-
else
  set iskeyword=-,@,48-57,_,128-167,224-235
endif

" The ID
syn keyword etpanTokenId contained id
" Global (global)
syn keyword etpanTokensAll contained across-folder display-charset
syn keyword etpanTokensAll contained editor-charset editor message-charset
syn keyword etpanTokensAll contained network-timeout poll-delay
syn keyword etpanTokensAll contained reply-quote-limit sendmail-path 
syn keyword etpanTokensAll contained thread-type
" Adress book (abook-config)
syn keyword etpanTokensAll contained base binddn bindpw cn file filter givename
syn keyword etpanTokensAll contained hostname mail port sizelimit sn timeout
syn keyword etpanTokensAll contained type version
" Accounts (account)
syn keyword etpanTokensAll contained account addr default-account display name
syn keyword etpanTokensAll contained privacy-driver privacy-encryption
syn keyword etpanTokensAll contained signature
" Colors (color)
syn keyword etpanTokensAll contained blink bold background dim foreground
syn keyword etpanTokensAll contained name reverse standout underline
" Discovery (discovery)
syn keyword etpanTokensAll contained account draft location name sent storage
syn keyword etpanTokensAll contained type
" MIME-config (mime-config)
syn keyword etpanTokensAll contained type type-match renderer viewer name
syn keyword etpanTokensAll contained encoding ext
" Sender (sender)
syn keyword etpanTokensAll contained command host login name password port type
" SMIME-config (smime-config)
syn keyword etpanTokensAll contained CA-check CA-dir auto-extract-cert
syn keyword etpanTokensAll contained cert-dir private-keys-dir
" Storages (storage)
syn keyword etpanTokensAll contained auth cached command connection hostname
syn keyword etpanTokensAll contained location login name password port type
" Vfolder tree (vfolder)
syn keyword etpanTokensAll contained account draft default-folder default-sent
syn keyword etpanTokensAll contained default-draft folder location mail-to max
syn keyword etpanTokensAll contained name poll sent storage 

" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_etpancfg_syn_inits")
  if version < 508
    let did_etpancfg_syn_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif
  HiLink etpanTokenId   Special
  HiLink etpanTokensAll Keyword
  HiLink etpanToken     Normal
  HiLink etpanComment   Comment
  "HiLink etpanValue     String
  delcommand HiLink
endif


let b:current_syntax = "etpancfg"
" vim:ts=2 expandtab
