------------------------------------------------------------------------
-- Copyright (C) 2002,2003 Daniel Heck
--
-- This program is free software; you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along
-- with this program; if not, write to the Free Software Foundation, Inc.,
-- 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
--
-- $Id: startup.lua,v 1.16 2003/09/12 21:40:20 dheck Exp $
------------------------------------------------------------------------

function Require(filename)
    dofile(enigma.FindDataFile(filename))
end

------------------------------
-- Extensions to C packages --
------------------------------

function options.LevelStat (key, stat)
    -- Enigma accidentally used to save times in the wrong numeric format.
    -- The following two lines works around this problem
    if stat[1] < 0 then stat[1] = -1 end
    if stat[2] < 0 then stat[2] = -1 end
    if stat[3] < 0 then stat[3] = 0 end

    local status = LevelStatus:new(stat[1], stat[2], stat[3], stat[4] or 0)
    gsub(key, "([^#]*)#(.+)", function (pack,lev)
                                  options.SetLevelStatus(pack,lev, %status)
                              end)
    status:delete()
end

----------------------------------
-- Define some new object types --
----------------------------------
function def_stone(name, sound)
    world.DefineSimpleStone(name,sound or "st-stone",0,0)
end
function def_stone_hollow(name)
    world.DefineSimpleStone(name,"",1,0)
end
function def_stone_glass(name, sound)
    world.DefineSimpleStone(name,sound or "st-stone",0,1)
end
function def_stone_movable_glass(name, sound)
    world.DefineSimpleStoneMovable(name,sound or "st-stone",1)
end
function def_stone_movable(name, sound)
    world.DefineSimpleStoneMovable(name,sound or "st-stone",0)
end
function def_floor(name, frict, mfactor)
    world.DefineSimpleFloor(name, frict, mfactor)
end

def_stone_movable("st-brownie", "st-thud")
def_stone("st-invisible")
def_stone("st-marble")
def_stone_movable("st-marble_move")
def_stone_hollow("st-marble_hole")
def_stone("st-rock1")
def_stone_movable("st-rock1_move")
def_stone_hollow("st-rock1_hole")
def_stone("st-rock2")
def_stone_hollow("st-rock2_hole")
def_stone("st-rock3")
def_stone_movable("st-rock3_move")
def_stone_hollow("st-rock3_hole")
def_stone("st-rock4")
def_stone("st-rock5")
def_stone("st-rock6")
def_stone("st-rock7")
def_stone("st-rock8")
def_stone("st-greenbrown")
def_stone_movable("st-greenbrown_move")
def_stone_hollow("st-greenbrown_hole")
def_stone("st-brick")
def_stone("st-woven")
def_stone("st-wood_001")
def_stone("st-bluegray")
def_stone_hollow("st-bluegray_hole")
def_stone("st-stone1")
def_stone("st-stone2")
def_stone("st-beads")
def_stone("st-metal")
def_stone("st-blue-sand")
def_stone("st-yellow")
def_stone("st-plain")

function mkoxydlikes(flavor)
   def_stone("st-likeoxyd"..flavor)
   def_stone("st-likeoxyd"..flavor.."-open")
end
mkoxydlikes("a")
mkoxydlikes("b")
mkoxydlikes("c")
mkoxydlikes("d")

def_stone_glass("st-glass")
def_stone_movable_glass("st-glass_move")
def_stone_glass("st-glass1")
def_stone_hollow("st-glass1_hole")
def_stone_glass("st-glass2")
def_stone_hollow("st-glass2_hole")
def_stone_glass("st-glass3")

-- Floor(kind, friction, mousefactor)
def_floor("fl-bluegray",    4.5,   1.5)
def_floor("fl-bluegreen",   6.0,   2.0)
def_floor("fl-bluegreenx",  0.4,   1.0)
def_floor("fl-brick",       4.0,   2.0)
def_floor("fl-bumps",       5.0,   1.2)
def_floor("fl-concrete",    4.5,   1.3)
def_floor("fl-dummy",       4.0,   2.5)
def_floor("fl-dunes",       1.3,   1.0)
def_floor("fl-floor_001",   1.5,   2.5)
def_floor("fl-gravel",      3.2,   1.5)
def_floor("fl-gray",        5.0,   3.0)
def_floor("fl-hay",         5.0,   1.5)
def_floor("fl-himalaya",    5.0,   2.0)
def_floor("fl-ice_001",     0.1,   0.1)
def_floor("fl-inverse",     3.0,  -2.0)
def_floor("fl-inverse2",    3.0,  -2.0)
def_floor("fl-leaves",      4.0,   1.5)
def_floor("fl-light",       2.2,   1.6)
def_floor("fl-marble",      6.4,   2.0)
def_floor("fl-metal",       3.0,   2.0)
def_floor("fl-mortar",      7.2,   1.8)
def_floor("fl-normal",      4.0,   2.0)
def_floor("fl-normal_x",    3.0,   2.0)
def_floor("fl-plank",       5.5,   2.0)
def_floor("fl-red",         0.9,   1.0)
def_floor("fl-rock",        3.0,   1.5)
def_floor("fl-rough",       7.0,   2.0)
def_floor("fl-rough_medium",5.0,   1.2)
def_floor("fl-rough_slow",  7.0,   0.5)
def_floor("fl-rough-blue",  7.0,   2.0)
def_floor("fl-rough-red",   7.0,   2.0)
def_floor("fl-sahara",      6.4,   2.0)
def_floor("fl-samba",       6.0,   2.0)
def_floor("fl-sand",        6.0,   2.0)
def_floor("fl-space",       0.0,   0.0)
def_floor("fl-springboard", 4.0,   2.0)
def_floor("fl-stone",       1.4,   1.0)
def_floor("fl-tigris",      6.0,   2.0)
def_floor("fl-wood",        6.4,   2.0)
def_floor("fl-stwood",      3.5,   2.0)
def_floor("fl-woven",       6.5,   3.0)
def_floor("fl-black",       3.0,   1.5)
def_floor("fl-white",       3.0,   1.5)
def_floor("fl-trigger",     3.0,   1.5)
def_floor("fl-abyss_fake",  3.0,   2.0)
